/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.entities.horse.behaviors.impl;

import com.alaharranhonor.swem.forge.ModRef;
import com.alaharranhonor.swem.forge.config.ClientConfig;
import com.alaharranhonor.swem.forge.config.ServerConfig;
import com.alaharranhonor.swem.forge.entities.horse.SWEMHorseEntityBase;
import com.alaharranhonor.swem.forge.entities.horse.behaviors.AbstractBehavior;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class BreedingBehavior
extends AbstractBehavior {
    private static final EntityDataAccessor<Boolean> FEMALE = SWEMHorseEntityBase.defineDataId(EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> INFERTILE = SWEMHorseEntityBase.defineDataId(EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> BREED_COOLDOWN = SWEMHorseEntityBase.defineDataId(EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> IN_LOVE_TIMER = SWEMHorseEntityBase.defineDataId(EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> TOTAL_OFFSPRINGS = SWEMHorseEntityBase.defineDataId(EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> PREGNANT = SWEMHorseEntityBase.defineDataId(EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> GESTATION_TIMER = SWEMHorseEntityBase.defineDataId(EntityDataSerializers.f_135028_);
    private Set<SWEMHorseEntityBase> foals = new HashSet<SWEMHorseEntityBase>();
    @Nullable
    private UUID loveCauseId;

    public BreedingBehavior(SWEMHorseEntityBase horse) {
        super(ModRef.res("breeding"), horse);
    }

    @Override
    public boolean shouldTick() {
        return this.horse.m_30614_() && !this.horse.m_9236_().m_5776_() && !this.horse.m_6162_();
    }

    @Override
    public void tick() {
        int gestationTimer;
        int loveTimer = this.getLoveTimer();
        if (loveTimer > 0) {
            this.setData(IN_LOVE_TIMER, --loveTimer);
        }
        if ((gestationTimer = this.getData(GESTATION_TIMER).intValue()) > 0) {
            this.setData(GESTATION_TIMER, --gestationTimer);
        }
        if (gestationTimer == 0 && this.getBreedCooldown() > 0) {
            this.setData(BREED_COOLDOWN, this.getBreedCooldown() - 1);
        }
        if (this.isFemale() && this.isPregnant() && gestationTimer == 0) {
            this.spawnFoals();
            this.setData(PREGNANT, false);
        }
        if (!this.isInfertile()) {
            int maxOffspring;
            int n = maxOffspring = this.isFemale() ? ServerConfig.maxMareBirths : ServerConfig.maxStallionCovers;
            if (maxOffspring > 0 && this.getTotalOffsprings() >= maxOffspring) {
                this.setInfertile(true);
            }
        }
    }

    public void breed(SWEMHorseEntityBase partner) {
        this.setInLove(0);
        if (this.isMale()) {
            this.setData(BREED_COOLDOWN, ServerConfig.stallionBreedingCooldownInSeconds * 20);
            this.setData(TOTAL_OFFSPRINGS, this.getTotalOffsprings() + 1);
            this.horse.emitYayParticles((ServerLevel)this.horse.m_9236_(), 4);
            return;
        }
        if (this.isFemale()) {
            Player loveCause;
            this.foals.clear();
            if (this.horse.m_217043_().m_188503_(ServerConfig.twinBirthChance) == 0) {
                this.createAndAddFoal((ServerLevel)this.horse.m_9236_(), partner);
            }
            this.createAndAddFoal((ServerLevel)this.horse.m_9236_(), partner);
            if (this.foals.isEmpty()) {
                this.horse.emitEchParticles((ServerLevel)this.horse.m_9236_(), 4);
                return;
            }
            this.setData(BREED_COOLDOWN, ServerConfig.mareBreedingCooldownInSeconds * 20);
            this.setData(PREGNANT, true);
            this.setData(GESTATION_TIMER, ServerConfig.mareGestationTimeInSeconds * 20);
            this.horse.m_9236_().m_7605_((Entity)this.horse, (byte)18);
            if (this.loveCauseId != null && !this.loveCauseId.equals(this.horse.m_21805_()) && (loveCause = this.horse.m_9236_().m_46003_(this.loveCauseId)) != null) {
                loveCause.m_5661_((Component)Component.m_237110_((String)"swem.horse.breed.pregnant.trusted", (Object[])new Object[]{this.horse.m_5446_().getString(), Math.round((float)this.getData(GESTATION_TIMER).intValue() / 20.0f / 60.0f)}), false);
            }
            this.horse.getPlayerOwner().ifPresent(player -> player.m_5661_((Component)Component.m_237110_((String)"swem.horse.breed.pregnant", (Object[])new Object[]{this.horse.m_5446_().getString(), Math.round((float)this.getData(GESTATION_TIMER).intValue() / 20.0f / 60.0f)}), false));
        }
    }

    private void createAndAddFoal(ServerLevel pLevel, SWEMHorseEntityBase father) {
        SWEMHorseEntityBase foal = this.createFoalFromBreeding(pLevel, father);
        if (foal != null) {
            this.foals.add(foal);
        }
    }

    private SWEMHorseEntityBase createFoalFromBreeding(ServerLevel pLevel, SWEMHorseEntityBase father) {
        SWEMHorseEntityBase offspring = (SWEMHorseEntityBase)this.horse.m_142606_(pLevel, (AgeableMob)father);
        if (offspring != null) {
            offspring.m_6863_(true);
        }
        return offspring;
    }

    private void spawnFoals() {
        ServerLevel level = (ServerLevel)this.horse.m_9236_();
        for (SWEMHorseEntityBase foal : this.foals) {
            ServerPlayer player;
            foal.m_7678_(this.horse.m_20185_(), this.horse.m_20186_(), this.horse.m_20189_(), 0.0f, 0.0f);
            if (this.horse.m_21805_() != null) {
                level.m_7654_().m_129927_().m_11002_(this.horse.m_21805_()).ifPresent(foal::tameWithName);
            }
            level.m_47205_((Entity)foal);
            if (this.loveCauseId == null || (player = (ServerPlayer)level.m_46003_(this.loveCauseId)) == null) continue;
            player.m_36220_(Stats.f_12937_);
            CriteriaTriggers.f_10581_.m_147278_(player, (Animal)this.horse, (Animal)this.horse, (AgeableMob)foal);
        }
        this.setData(TOTAL_OFFSPRINGS, this.getTotalOffsprings() + this.foals.size());
        this.foals.clear();
        this.horse.m_5496_(SoundEvents.f_11971_, 0.5f, 1.0f);
        this.horse.emitYayParticles((ServerLevel)this.horse.m_9236_(), 4);
    }

    public boolean canFallInLove() {
        return this.horse.m_30614_() && !this.horse.m_6162_() && !this.isInfertile() && !this.isInLove() && this.getBreedCooldown() <= 0;
    }

    public boolean canMate(SWEMHorseEntityBase partner) {
        if (this.horse.m_6162_()) {
            return false;
        }
        if (this.isInLove() && this.isFemale() != partner.getBreeding().isFemale()) {
            if (this.isFemale()) {
                return ServerConfig.maxMareBirths <= 0 || this.getTotalOffsprings() < ServerConfig.maxMareBirths;
            }
            return ServerConfig.maxStallionCovers <= 0 || this.getTotalOffsprings() < ServerConfig.maxStallionCovers;
        }
        return false;
    }

    public void fallInLove(@Nullable Player loveCause) {
        this.loveCauseId = null;
        if (loveCause != null) {
            this.loveCauseId = loveCause.m_20148_();
        }
        int loveTimer = (this.isMale() ? ServerConfig.stallionLoveTimeInSeconds : ServerConfig.mareLoveTimeInSeconds) * 20;
        this.setInLove(ServerConfig.permanentLoveMode ? -1 : loveTimer);
        this.horse.m_9236_().m_7605_((Entity)this.horse, (byte)18);
    }

    public void appendBreedingText(String horseName, StringBuilder text) {
        String pronoun = this.isFemale() ? "She" : "He";
        String pronoun2 = this.isFemale() ? "Her" : "His";
        text.append("\n").append(horseName).append(" is a ").append(this.getName().getString()).append(". ");
        if (this.isInfertile()) {
            text.append("\n").append(pronoun).append(" is ").append(this.isFemale() ? "infertile" : "gelding").append(". ");
        }
        if (this.isFemale()) {
            text.append("She is ").append(this.isPregnant() ? "" : "not ").append("pregnant. ");
            if (this.isPregnant()) {
                text.append("The foal is ").append(this.getPregnancyStage()).append("% grown.\n");
            }
        }
        text.append(pronoun).append(" has had ").append(this.getTotalOffsprings()).append(" foal(s). ");
        text.append(pronoun).append(" is ").append(this.isInLove() ? "" : "not ").append("in love.");
        text.append("\n");
        if (this.horse.getDam() != null) {
            text.append(pronoun2).append(" Dam is " + this.horse.getDam().getName()).append(", ");
        }
        if (this.horse.getSire() != null) {
            text.append(pronoun2).append(" Sire is " + this.horse.getSire().getName()).append(".\n");
        }
    }

    public Component addSymbol(Component component) {
        String symbolHexColor = this.isInfertile() ? ClientConfig.infertileIconColor : (this.isFemale() ? ClientConfig.femaleIconColor : ClientConfig.maleIconColor);
        return Component.m_237113_((String)(this.isFemale() ? "\u2640 " : "\u2642 ")).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131268_((String)symbolHexColor))).m_7220_((Component)component.m_6881_().m_130940_(ChatFormatting.WHITE));
    }

    public Component getInfertilityText() {
        return Component.m_237115_((String)(this.isFemale() ? "swem.breeding.infertile" : "swem.breeding.gelding"));
    }

    public Component getName() {
        if (this.isFemale()) {
            return Component.m_237115_((String)(this.horse.m_6162_() ? "horse.swem.gender.filly" : "horse.swem.gender.mare"));
        }
        return Component.m_237115_((String)(this.horse.m_6162_() ? "horse.swem.gender.colt" : "horse.swem.gender.stallion"));
    }

    public void advancePregnancy() {
        if (this.getData(GESTATION_TIMER) > 500) {
            this.setData(GESTATION_TIMER, 500);
        }
    }

    public void resetPregnancy() {
        this.setData(PREGNANT, false);
        this.setData(GESTATION_TIMER, 0);
        this.foals.clear();
    }

    public void resetBreedCooldown() {
        this.setData(BREED_COOLDOWN, 0);
    }

    public boolean canRefertile() {
        return ServerConfig.refertileHorses && this.isInfertile();
    }

    public boolean isPregnant() {
        return this.isFemale() && this.getData(PREGNANT) != false;
    }

    public int getPregnancyStage() {
        return Math.abs((int)Math.floor((float)this.getData(GESTATION_TIMER).intValue() / ((float)ServerConfig.mareGestationTimeInSeconds * 20.0f) * 100.0f) - 100);
    }

    public void setOffspringCount(int count) {
        this.setData(TOTAL_OFFSPRINGS, count);
        this.setInfertile(false);
    }

    public void setInfertile(boolean infertile) {
        this.setData(INFERTILE, infertile);
    }

    public void setFemale(boolean female) {
        this.setData(FEMALE, female);
    }

    public void setInLove(int timer) {
        this.setData(IN_LOVE_TIMER, timer);
    }

    public int getBreedCooldown() {
        return this.getData(BREED_COOLDOWN);
    }

    public boolean isInLove() {
        return this.getData(IN_LOVE_TIMER) != 0;
    }

    public int getLoveTimer() {
        return this.getData(IN_LOVE_TIMER);
    }

    public boolean isInfertile() {
        return this.getData(INFERTILE);
    }

    public boolean isFertile() {
        return !this.isInfertile();
    }

    public boolean isFemale() {
        return this.getData(FEMALE);
    }

    public boolean isMale() {
        return !this.isFemale();
    }

    public int getTotalOffsprings() {
        return this.getData(TOTAL_OFFSPRINGS);
    }

    @Override
    public void defineData(SynchedEntityData dataManager) {
        dataManager.m_135372_(FEMALE, (Object)false);
        dataManager.m_135372_(INFERTILE, (Object)false);
        dataManager.m_135372_(BREED_COOLDOWN, (Object)0);
        dataManager.m_135372_(IN_LOVE_TIMER, (Object)0);
        dataManager.m_135372_(GESTATION_TIMER, (Object)0);
        dataManager.m_135372_(TOTAL_OFFSPRINGS, (Object)0);
        dataManager.m_135372_(PREGNANT, (Object)false);
    }

    @Override
    public CompoundTag save(CompoundTag tag) {
        tag.m_128379_("Female", this.isFemale());
        tag.m_128379_("Infertile", this.isInfertile());
        tag.m_128405_("BreedCooldown", this.getBreedCooldown());
        tag.m_128405_("InLoveTimer", this.getLoveTimer());
        tag.m_128405_("TotalOffsprings", this.getData(TOTAL_OFFSPRINGS).intValue());
        if (this.isFemale()) {
            tag.m_128405_("GestationTimer", this.getData(GESTATION_TIMER).intValue());
            tag.m_128379_("Pregnant", this.isPregnant());
            ListTag foalsTag = new ListTag();
            for (SWEMHorseEntityBase foal : this.foals) {
                foalsTag.add((Object)foal.serializeNBT());
            }
            tag.m_128365_("Foals", (Tag)foalsTag);
            if (this.loveCauseId != null) {
                tag.m_128362_("LoveCause", this.loveCauseId);
            }
        }
        return tag;
    }

    @Override
    public void load(CompoundTag tag) {
        this.setFemale(tag.m_128471_("Female"));
        this.setInfertile(tag.m_128471_("Infertile"));
        this.setData(BREED_COOLDOWN, tag.m_128451_("BreedCooldown"));
        this.setData(IN_LOVE_TIMER, tag.m_128451_("InLoveTimer"));
        this.setData(TOTAL_OFFSPRINGS, tag.m_128451_("TotalOffsprings"));
        if (this.isFemale()) {
            this.setData(GESTATION_TIMER, tag.m_128451_("GestationTimer"));
            this.setData(PREGNANT, tag.m_128471_("Pregnant"));
            this.foals.clear();
            ListTag foalsTag = tag.m_128437_("Foals", 10);
            foalsTag.stream().map(CompoundTag.class::cast).forEach(foalTag -> {
                Optional entity = EntityType.m_20642_((CompoundTag)foalTag, (Level)this.horse.m_9236_());
                entity.filter(e -> e instanceof SWEMHorseEntityBase).map(e -> (SWEMHorseEntityBase)e).ifPresent(this.foals::add);
            });
            if (tag.m_128441_("LoveCause")) {
                this.loveCauseId = tag.m_128342_("LoveCause");
            }
        }
    }
}

