/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.entities.horse;

import com.alaharranhonor.swem.forge.entities.HorseAnimations;
import com.alaharranhonor.swem.forge.entities.horse.SWEMHorseEntityBase;
import com.alaharranhonor.swem.forge.entities.horse.behaviors.impl.ActionBehavior;
import com.alaharranhonor.swem.forge.entities.horse.behaviors.impl.EatingBehavior;
import com.alaharranhonor.swem.forge.entities.horse.behaviors.impl.FlightBehavior;
import com.alaharranhonor.swem.forge.entities.horse.behaviors.impl.LayingBehavior;
import com.alaharranhonor.swem.forge.entities.horse.behaviors.impl.RRPAnimBehavior;
import com.alaharranhonor.swem.forge.entities.horse.behaviors.impl.SleepingBehavior;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SWEMHorseEntity
extends SWEMHorseEntityBase {
    private final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int idleAnimTimer = 0;
    private int idleAnimCooldown = 0;

    public SWEMHorseEntity(EntityType<? extends SWEMHorseEntityBase> type, Level worldIn) {
        super(type, worldIn);
        this.f_19811_ = true;
    }

    @Override
    public void m_8119_() {
        if (this.m_9236_().f_46443_) {
            this.idleAnimTimer = Math.max(this.idleAnimTimer - 1, 0);
            this.idleAnimCooldown = Math.max(this.idleAnimCooldown - 1, 0);
        }
        super.m_8119_();
    }

    public <E extends GeoAnimatable> PlayState horseAnimationHandler(AnimationState<E> event) {
        RRPAnimBehavior rrpAnim;
        if (this.f_19803_) {
            event.getController().forceAnimationReset();
        }
        if ((rrpAnim = this.getBehavior(RRPAnimBehavior.class)).isActive()) {
            String animation = rrpAnim.getAnimation();
            return event.setAndContinue(RawAnimation.begin().thenLoop(animation));
        }
        FlightBehavior flight = this.getBehavior(FlightBehavior.class);
        if (flight.isFlying()) {
            FlightBehavior.AccelerationState accelerationState = flight.getAccelerationState();
            event.getController().transitionLength(4);
            if (accelerationState == FlightBehavior.AccelerationState.RISE) {
                return event.setAndContinue(HorseAnimations.GOING_UP);
            }
            if (accelerationState == FlightBehavior.AccelerationState.DIVE) {
                return event.setAndContinue(HorseAnimations.DIVE);
            }
            if (accelerationState == FlightBehavior.AccelerationState.ELEVATE) {
                return event.setAndContinue(HorseAnimations.GOING_UP);
            }
            if (accelerationState == FlightBehavior.AccelerationState.FLUTTER) {
                return event.setAndContinue(HorseAnimations.FLUTTER);
            }
            if (accelerationState == FlightBehavior.AccelerationState.FLOAT) {
                return event.setAndContinue(HorseAnimations.SLOW_DOWN);
            }
            FlightBehavior.TurnState turnState = flight.getTurnState();
            if (turnState != FlightBehavior.TurnState.NONE) {
                return event.setAndContinue(turnState == FlightBehavior.TurnState.LEFT ? HorseAnimations.TURN_LEFT : HorseAnimations.TURN_RIGHT);
            }
            if (accelerationState == FlightBehavior.AccelerationState.ACCELERATE) {
                return event.setAndContinue(HorseAnimations.SPEED_UP);
            }
            return event.setAndContinue(HorseAnimations.FLOAT_DOWN);
        }
        if (this.m_6069_()) {
            return event.setAndContinue(HorseAnimations.SWIM);
        }
        if (((Boolean)this.f_19804_.m_135370_(FLUTTER)).booleanValue()) {
            return event.setAndContinue(HorseAnimations.FLUTTER);
        }
        if (this.jumpHeight != 0.0) {
            int jumpAnimIndex = Math.min(Mth.m_14165_((double)this.jumpHeight), 5) - 1;
            return event.setAndContinue(HorseAnimations.JUMPS[jumpAnimIndex]);
        }
        LayingBehavior layingBehavior = this.getBehavior(LayingBehavior.class);
        if (layingBehavior.isVisuallyLayingDown()) {
            return event.setAndContinue(HorseAnimations.LAYING_DOWN_LOOP);
        }
        SleepingBehavior sleepingBehavior = this.getBehavior(SleepingBehavior.class);
        if (sleepingBehavior.isVisuallySleeping()) {
            return event.setAndContinue(HorseAnimations.SLEEPING_LOOP);
        }
        EatingBehavior eatingBehavior = this.getBehavior(EatingBehavior.class);
        if (eatingBehavior.isVisuallyEating()) {
            EatingBehavior.EatingType eatingType = eatingBehavior.getVisualEatingType();
            return event.setAndContinue(eatingType == EatingBehavior.EatingType.HALF ? HorseAnimations.HALF_HEIGHT_EATING_LOOP : HorseAnimations.EATING_LOOP);
        }
        if (event.isMoving() || this.isBeingMovedByPlayer()) {
            if (this.isWalkingBackwards) {
                return event.setAndContinue(HorseAnimations.BACKWARDS_WALK);
            }
            return event.setAndContinue(this.getGait().getAnimation(this));
        }
        if (this.isVisuallySad()) {
            return event.setAndContinue(HorseAnimations.SAD_STAND_IDLE);
        }
        if (this.idleAnimTimer > 0) {
            return PlayState.CONTINUE;
        }
        if (this.idleAnimCooldown == 0) {
            float chance = this.f_19796_.m_188501_();
            if (chance < 0.001f) {
                this.idleAnimTimer = 65;
                event.setAndContinue(HorseAnimations.SHAKE);
            } else if (chance < 0.002f) {
                this.idleAnimTimer = 79;
                event.setAndContinue(HorseAnimations.TAIL_SWISH);
            } else if (chance < 0.003f) {
                this.idleAnimTimer = 94;
                event.setAndContinue(HorseAnimations.SCRATCH);
            }
            if (this.idleAnimTimer > 0) {
                this.idleAnimCooldown = 100 + this.idleAnimTimer;
                return PlayState.CONTINUE;
            }
        }
        this.idleAnimTimer = 0;
        return event.setAndContinue(HorseAnimations.STAND_IDLE);
    }

    public <E extends GeoAnimatable> PlayState foalAnimationHandler(AnimationState<E> event) {
        if (event.isMoving()) {
            return event.setAndContinue(RawAnimation.begin().thenPlay("gait.walk"));
        }
        float chance = new Random().nextFloat();
        if (chance < 0.95f) {
            return event.setAndContinue(RawAnimation.begin().thenPlay("idle.stand"));
        }
        return event.setAndContinue(RawAnimation.begin().thenPlay("idle.shake").thenPlay("idle.stand"));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        AnimationController controller = new AnimationController((GeoAnimatable)this, "horse", 2, event -> this.m_6162_() ? this.foalAnimationHandler(event) : this.horseAnimationHandler(event)).setSoundKeyframeHandler(e -> {});
        controller.triggerableAnim(HorseAnimations.Keys.LAYING_DOWN, HorseAnimations.LAYING_DOWN);
        controller.triggerableAnim(HorseAnimations.Keys.GETTING_UP, HorseAnimations.GETTING_UP);
        controller.triggerableAnim(HorseAnimations.Keys.SLEEPING_IN, HorseAnimations.SLEEPING_IN);
        controller.triggerableAnim(HorseAnimations.Keys.SLEEPING_OUT, HorseAnimations.SLEEPING_OUT);
        controller.triggerableAnim(HorseAnimations.Keys.LEAN_IN, HorseAnimations.LEAN_IN);
        controller.triggerableAnim(HorseAnimations.Keys.HALF_LEAN_IN, HorseAnimations.HALF_LEAN_IN);
        controller.triggerableAnim(HorseAnimations.Keys.LEAN_OUT, HorseAnimations.LEAN_OUT);
        controller.triggerableAnim(HorseAnimations.Keys.HALF_LEAN_OUT, HorseAnimations.HALF_LEAN_OUT);
        controller.triggerableAnim(HorseAnimations.Keys.LAUNCH, HorseAnimations.LAUNCH);
        controller.triggerableAnim(HorseAnimations.Keys.FLIGHT_HURT, HorseAnimations.FLIGHT_HURT);
        Arrays.stream(ActionBehavior.Action.values()).forEach(action -> controller.triggerableAnim(action.animationKey, action.animation));
        controllers.add(new AnimationController[]{controller});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }
}

