/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.container;

import com.alaharranhonor.swem.forge.container.LockSlot;
import com.alaharranhonor.swem.forge.registry.BlockSetup;
import com.alaharranhonor.swem.forge.registry.MenuSetup;
import com.alaharranhonor.swem.forge.tileentity.LockerBE;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;

public class LockerContainer
extends AbstractContainerMenu {
    public final LockerBE locker;
    private final ContainerLevelAccess canInteractWithCallable;
    private final boolean leftSideOpened;
    public static final int ROW_COUNT = 2;

    public LockerContainer(int id, Inventory playerInventory, FriendlyByteBuf data) {
        this(id, playerInventory, LockerContainer.getTileEntity(playerInventory, data), data.readBoolean());
    }

    public LockerContainer(int id, Inventory playerInventory, LockerBE locker, boolean leftSideOpened) {
        super((MenuType)MenuSetup.LOCKER_CONTAINER.get(), id);
        this.locker = locker;
        this.leftSideOpened = leftSideOpened;
        this.canInteractWithCallable = ContainerLevelAccess.m_39289_((Level)locker.m_58904_(), (BlockPos)locker.m_58899_());
        this.initSlots(playerInventory);
    }

    private static LockerBE getTileEntity(Inventory inventory, FriendlyByteBuf data) {
        Objects.requireNonNull(inventory, "Inventory cannot be null");
        Objects.requireNonNull(data, "Packet Data cannot be null");
        BlockEntity tileAtPos = inventory.f_35978_.m_9236_().m_7702_(data.m_130135_());
        if (tileAtPos instanceof LockerBE) {
            return (LockerBE)tileAtPos;
        }
        throw new IllegalStateException("Tile entity is not correct." + tileAtPos);
    }

    private void initSlots(Inventory playerInventory) {
        int slot;
        int row;
        for (row = 0; row < 2; ++row) {
            for (slot = 0; slot < 9; ++slot) {
                int index = slot + row * 9 + (this.leftSideOpened ? 0 : 18);
                this.m_38897_(new Slot((Container)this.locker, index, 8 + slot * 18, 29 + row * 18));
            }
        }
        this.m_38897_(new LockSlot(this.locker.getLockSlot(), this.leftSideOpened ? 0 : 1, 152, 8, this.locker::canModifyLock){

            public boolean m_5857_(ItemStack pStack) {
                return pStack.m_150930_(Items.f_42656_);
            }
        });
        for (row = 0; row < 3; ++row) {
            for (slot = 0; slot < 9; ++slot) {
                this.m_38897_(new Slot((Container)playerInventory, slot + row * 9 + 9, 8 + slot * 18, 78 + row * 18));
            }
        }
        for (int slot2 = 0; slot2 < 9; ++slot2) {
            this.m_38897_(new Slot((Container)playerInventory, slot2, 8 + slot2 * 18, 136));
        }
    }

    public boolean m_6875_(Player playerIn) {
        return this.locker.m_7525_(playerIn) && LockerContainer.m_38889_((ContainerLevelAccess)this.canInteractWithCallable, (Player)playerIn, (Block)((Block)BlockSetup.LOCKER.get()));
    }

    public void m_150399_(int pSlotId, int pButton, ClickType pClickType, Player pPlayer) {
        LockSlot lock;
        Slot slot;
        if (pSlotId > 0 && pSlotId < this.f_38839_.size() && (slot = this.m_38853_(pSlotId)) instanceof LockSlot && !(lock = (LockSlot)slot).canModify(pPlayer)) {
            return;
        }
        super.m_150399_(pSlotId, pButton, pClickType, pPlayer);
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack stack = slot.m_7993_();
            itemstack = stack.m_41777_();
            if (index < 30 ? !this.m_38903_(stack, 30, this.f_38839_.size(), true) : !this.m_38903_(stack, 0, 30, false)) {
                return ItemStack.f_41583_;
            }
            if (stack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }

    public int getRowCount() {
        return 2;
    }
}

