/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.community.content.coats;

import com.alaharranhonor.swem.forge.community.CommunityPack;
import com.alaharranhonor.swem.forge.community.ContentPack;
import com.alaharranhonor.swem.forge.community.LoadingPackException;
import com.alaharranhonor.swem.forge.community.content.coats.RawCoatData;
import com.alaharranhonor.swem.forge.entities.horse.HorseModelType;
import com.alaharranhonor.swem.forge.entities.horse.coats.CoatManager;
import com.alaharranhonor.swem.forge.entities.horse.coats.HorseColor;
import com.alaharranhonor.swem.forge.util.serializers.NamespacedResourceLocationSerializer;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;

public class CoatContentPack
extends ContentPack<RawCoatData> {
    private final Gson gson = new GsonBuilder().registerTypeAdapter(ResourceLocation.class, (Object)new NamespacedResourceLocationSerializer(this.getPack().getId())).registerTypeAdapter(HorseModelType.class, (Object)new HorseModelType.Serializer()).registerTypeAdapter(HorseColor.class, (Object)new HorseColor.Serializer()).create();
    public final Set<ResourceLocation> texturesToLoad = new HashSet<ResourceLocation>();

    public CoatContentPack(CommunityPack pPack) {
        super(pPack);
    }

    @Override
    protected void load() throws LoadingPackException {
        try {
            this.loadCoat(this.getDataPath().toFile());
        }
        catch (IOException e) {
            throw new LoadingPackException("Failed to load coat for pack " + this.getPack().getId(), e);
        }
    }

    private void loadCoat(File file) throws IOException {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                this.loadCoat(child);
            }
            return;
        }
        if (!file.getName().endsWith(".json")) {
            return;
        }
        JsonObject json = JsonParser.parseReader((Reader)Files.newBufferedReader(file.toPath())).getAsJsonObject();
        RawCoatData data = new RawCoatData(this);
        data.load(json);
        data.id = this.getPack().res(file.getName().substring(0, file.getName().length() - 5));
        CoatManager.register(data.asCoat());
        this.add(data);
    }

    @Override
    public String name() {
        return "coats";
    }
}

