/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.community;

import com.alaharranhonor.swem.forge.community.CommunityPack;
import com.alaharranhonor.swem.forge.community.ContentData;
import com.alaharranhonor.swem.forge.community.LoadingPackException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Spliterator;
import org.jetbrains.annotations.NotNull;

public abstract class ContentPack<T extends ContentData>
implements Iterable<T> {
    private final CommunityPack pack;
    private final Set<T> content = new HashSet<T>();

    public ContentPack(CommunityPack pPack) {
        this.pack = pPack;
    }

    protected abstract void load() throws LoadingPackException;

    protected void unload() {
        this.content.clear();
    }

    protected void add(T data) {
        this.content.add(data);
    }

    public Set<T> getContent() {
        return Collections.unmodifiableSet(this.content);
    }

    public abstract String name();

    public CommunityPack getPack() {
        return this.pack;
    }

    public Path getDataPath() {
        return this.getPack().getJsonsPath().resolve(this.name());
    }

    public Path getTexturePath() {
        return this.getPack().getTexturesPath().resolve(this.name());
    }

    @Override
    public Spliterator<T> spliterator() {
        return this.content.spliterator();
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return this.content.iterator();
    }
}

