/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.community;

import com.alaharranhonor.swem.forge.ModRef;
import com.alaharranhonor.swem.forge.community.ContentPack;
import com.alaharranhonor.swem.forge.community.LoadingPackException;
import com.alaharranhonor.swem.forge.community.content.coats.CoatContentPack;
import com.alaharranhonor.swem.forge.community.content.tack.RawTackData;
import com.alaharranhonor.swem.forge.community.content.tack.TackContentPack;
import com.alaharranhonor.swem.forge.entities.horse.coats.CoatManager;
import com.alaharranhonor.swem.forge.entities.horse.coats.HorseCoat;
import com.alaharranhonor.swem.forge.entities.horse.coats.HorseColor;
import com.alaharranhonor.swem.forge.items.tack.TackItem;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;

public class CommunityPack {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).registerTypeAdapter(HorseColor.class, (Object)new HorseColor.Serializer()).create();
    private final Path packPath;
    private final String packId;
    private final Set<ContentPack<?>> contentPacks = new HashSet();
    private final TackContentPack tack;
    private final CoatContentPack coats;

    private CommunityPack(Path packPath, String packId) {
        this.packPath = packPath;
        this.packId = packId;
        this.tack = this.addContent(new TackContentPack(this));
        this.coats = this.addContent(new CoatContentPack(this));
    }

    public ResourceLocation res(String name) {
        return new ResourceLocation(this.packId, name);
    }

    public void onRegisterEvent(RegisterEvent event) {
        for (RawTackData tackData : this.getTack().getContent()) {
            event.register(ForgeRegistries.Keys.ITEMS, helper -> {
                TackItem item = tackData.type.createItem(tackData);
                helper.register(tackData.id, (Object)item);
                this.getTack().onTackRegistered(tackData.id, item);
            });
        }
    }

    public String getId() {
        return this.packId;
    }

    public void load() throws LoadingPackException {
        for (ContentPack<?> contentPack : this.contentPacks) {
            contentPack.load();
        }
    }

    public void onLoaded() {
        ModRef.LOGGER.info("Loaded {}", (Object)this.packId);
        StringBuilder sb = new StringBuilder();
        sb.append("Coats: ").append(this.coats.getContent().size());
        sb.append(", Tack: ").append(this.tack.getContent().size()).append('\n');
        ModRef.LOGGER.info((CharSequence)sb);
    }

    public void unload() {
        for (ContentPack<?> contentPack : this.contentPacks) {
            contentPack.unload();
        }
    }

    private <T extends ContentPack<?>> T addContent(T content) {
        this.contentPacks.add(content);
        return content;
    }

    public CoatContentPack getCoats() {
        return this.coats;
    }

    public TackContentPack getTack() {
        return this.tack;
    }

    public Path getPath() {
        return this.packPath;
    }

    public Path getJsonsPath() {
        return this.packPath.resolve("jsons");
    }

    public Path getCoatsDataPath() {
        return this.getJsonsPath().resolve("coats");
    }

    public Path getTexturesPath() {
        return this.packPath.resolve("textures");
    }

    public static CommunityPack load(Path packPath, String packId) throws Exception {
        CommunityPack pack = new CommunityPack(packPath, packId);
        pack.load();
        return pack;
    }

    private void loadCoats() throws IOException {
        File[] coatFiles = this.getCoatsDataPath().toFile().listFiles();
        if (coatFiles == null) {
            return;
        }
        for (File file : coatFiles) {
            if (file.isDirectory() || !file.getPath().endsWith(".json")) continue;
            String fileName = file.getName().substring(0, file.getName().length() - 5);
            ResourceLocation coatId = new ResourceLocation(this.packId, fileName);
            try (FileReader reader = new FileReader(file);){
                HorseCoat coat = (HorseCoat)GSON.fromJson((Reader)reader, HorseCoat.class);
                if (coat == null) {
                    ModRef.LOGGER.warn("Invalid coat json for {}. Skipping.", (Object)file.getName());
                    continue;
                }
                coat.setId(coatId);
                CoatManager.register(coat);
            }
            catch (Exception e) {
                ModRef.LOGGER.error("Could not load coat {}. Reason: {}", (Object)coatId, (Object)e.getLocalizedMessage());
            }
        }
    }
}

