/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.community;

import com.alaharranhonor.swem.forge.ModRef;
import com.alaharranhonor.swem.forge.community.CommunityPack;
import com.alaharranhonor.swem.forge.community.LoadingPackException;
import java.io.File;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.loading.FMLPaths;
import org.jetbrains.annotations.NotNull;

public class CommunityManager {
    public static final Path COMMUNITY_DIR = FMLPaths.CONFIGDIR.get().resolve("swem").resolve("community-packs");
    private final Path communityDirPath;
    private final Set<CommunityPack> communityPacks = new HashSet<CommunityPack>();

    public CommunityManager(Path path) {
        this.communityDirPath = path;
    }

    public Set<CommunityPack> getPacks() {
        return Collections.unmodifiableSet(this.communityPacks);
    }

    public void loadPacks() throws LoadingPackException {
        File[] packDirs = this.getPackFiles();
        if (packDirs.length == 0) {
            ModRef.LOGGER.info("No community packs found.");
            return;
        }
        for (File packDir : packDirs) {
            if (!packDir.isDirectory()) continue;
            String packId = packDir.getName();
            if (!ResourceLocation.m_135843_((String)packId)) {
                ModRef.LOGGER.warn("Invalid pack name. Non [a-z0-9_.-] character in: {}", (Object)packId);
                continue;
            }
            try {
                CommunityPack pack = CommunityPack.load(this.communityDirPath.resolve(packId), packId);
                this.communityPacks.add(pack);
                pack.onLoaded();
            }
            catch (Exception e) {
                ModRef.LOGGER.error("Failed to load " + packId, (Throwable)e);
                e.printStackTrace();
            }
        }
        ModRef.LOGGER.info("Loaded " + this.communityPacks.size() + " community packs");
    }

    @NotNull
    private File[] getPackFiles() throws LoadingPackException {
        File communityDir = this.communityDirPath.toFile();
        if (communityDir.exists() && !communityDir.isDirectory()) {
            throw new LoadingPackException("'community-packs' must be a folder.");
        }
        if (!communityDir.exists() && !communityDir.mkdirs()) {
            throw new LoadingPackException("Could not create community directory.");
        }
        File[] packDirs = communityDir.listFiles();
        if (packDirs == null) {
            throw new LoadingPackException("Could not get community packs contents.");
        }
        return packDirs;
    }
}

