/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.client.gui.widgets;

import com.alaharranhonor.swem.forge.client.gui.screens.JumpScreen;
import com.alaharranhonor.swem.forge.client.gui.widgets.CycableButton;
import com.alaharranhonor.swem.forge.network.protocol.SWEMPackets;
import com.alaharranhonor.swem.forge.network.protocol.game.jumps.ServerboundJumpsActionPacket;
import com.alaharranhonor.swem.forge.util.SWEMUtil;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class ColorChangerButton
extends CycableButton {
    private final JumpScreen screen;
    private int layer = -1;

    public ColorChangerButton(int x, int y, int width, int height, Component title, JumpScreen screen) {
        super(x, y, width, height, title, new Press());
        this.screen = screen;
    }

    public JumpScreen getScreen() {
        return this.screen;
    }

    public void setLayer(int layer) {
        this.layer = layer;
    }

    @NotNull
    public Component m_6035_() {
        if (this.screen.layerAmount < this.layer) {
            return Component.m_237113_((String)"White");
        }
        String colorName = SWEMUtil.logicalByIndex(this.screen.layerColors.get(this.layer)).m_41065_();
        String[] names = colorName.split("_");
        StringBuilder finalName = new StringBuilder();
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            String subName = name.substring(1);
            char firstChar = Character.toUpperCase(name.charAt(0));
            finalName.append(firstChar).append(subName);
            if (i + 1 >= names.length) continue;
            finalName.append(" ");
        }
        return Component.m_237113_((String)finalName.toString());
    }

    public static class Press
    implements CycableButton.IPressable {
        @Override
        public void onPress(CycableButton press) {
            ColorChangerButton button = (ColorChangerButton)press;
            SWEMPackets.sendToServer(new ServerboundJumpsActionPacket(ServerboundJumpsActionPacket.Action.CHANGE_COLOR_FORWARD, (byte)button.layer));
        }

        @Override
        public void onRightPress(CycableButton press) {
            ColorChangerButton button = (ColorChangerButton)press;
            SWEMPackets.sendToServer(new ServerboundJumpsActionPacket(ServerboundJumpsActionPacket.Action.CHANGE_COLOR_BACKWARDS, (byte)button.layer));
        }
    }
}

