/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.client.gui.overlays;

import com.alaharranhonor.swem.forge.ModRef;
import com.alaharranhonor.swem.forge.config.ClientConfig;
import com.alaharranhonor.swem.forge.entities.horse.SWEMHorseEntityBase;
import com.alaharranhonor.swem.forge.entities.horse.behaviors.impl.FlightBehavior;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;

public class OverlaySetup {
    private static final ResourceLocation GUI_ICONS_LOCATION = ModRef.res("textures/gui/icons.png");
    public static final IGuiOverlay GAIT_HUD = (gui, guiGraphics, partialTick, width, height) -> {
        Entity patt856$temp = Minecraft.m_91087_().f_91074_.m_20202_();
        if (patt856$temp instanceof SWEMHorseEntityBase) {
            SWEMHorseEntityBase horse = (SWEMHorseEntityBase)patt856$temp;
            if (!Minecraft.m_91087_().f_91066_.f_92062_ && ((Boolean)ClientConfig.GAIT_HUD_ENABLED.get()).booleanValue() && !horse.m_6069_()) {
                String text = horse.getGait().getText();
                FlightBehavior flight = horse.getBehavior(FlightBehavior.class);
                if (flight.isLaunchingOrFlying()) {
                    FlightBehavior.AccelerationState acceleration = flight.getAccelerationState();
                    FlightBehavior.TurnState turn = flight.getTurnState();
                    text = flight.isLaunching() ? "Launching" : (acceleration == FlightBehavior.AccelerationState.RISE || acceleration == FlightBehavior.AccelerationState.DIVE || acceleration == FlightBehavior.AccelerationState.FLOAT ? acceleration.name : (turn != FlightBehavior.TurnState.NONE ? turn.name : acceleration.name));
                }
                float xPos = (float)width / 2.0f + 90.0f + 4.0f + (float)((Integer)ClientConfig.GAIT_HUD_X_OFFSET.get()).intValue();
                int yPos = height - 14 + (Integer)ClientConfig.GAIT_HUD_Y_OFFSET.get();
                guiGraphics.drawString(gui.m_93082_(), text, xPos, (float)yPos, ((Integer)ClientConfig.GAIT_HUD_TEXT_COLOR.get()).intValue(), false);
            }
        }
    };
    public static final IGuiOverlay TIERED_JUMP_BAR_HUD = (gui, guiGraphics, partialTick, width, height) -> {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        PlayerRideableJumping vehicle = player.m_245714_();
        if (vehicle == null || !vehicle.m_7132_() || Minecraft.m_91087_().f_91066_.f_92062_) {
            return;
        }
        Entity patt2620$temp = player.m_20202_();
        if (patt2620$temp instanceof SWEMHorseEntityBase) {
            SWEMHorseEntityBase horse = (SWEMHorseEntityBase)patt2620$temp;
            Minecraft.m_91087_().m_91307_().m_6180_("swem:tieredJumpBar");
            gui.setupOverlayRenderState(true, false);
            int xPos = width / 2 - 100;
            float f = player.m_108634_();
            int i = 201;
            int j = (int)(f * 200.0f);
            int level = horse.progressionManager.getJumpLeveling().getLevel();
            float modifier = ((float)level + 1.0f) / 5.0f;
            int amountOfBarToDraw = (int)((float)j * modifier);
            int k = height - 32 + 3;
            guiGraphics.m_280163_(GUI_ICONS_LOCATION, xPos, k, 0.0f, (float)(5 * level), i, 5, 201, 30);
            if (j > 0) {
                guiGraphics.m_280163_(GUI_ICONS_LOCATION, xPos + 1, k, (float)(201 - (level + 1) * 40), 25.0f, amountOfBarToDraw, 5, 201, 30);
            }
            Minecraft.m_91087_().m_91307_().m_7238_();
        }
    };
}

