/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.blocks;

import com.alaharranhonor.swem.forge.blocks.SWEMBlockStateProperties;
import com.alaharranhonor.swem.forge.items.TackBoxBlockItem;
import com.alaharranhonor.swem.forge.registry.BlockEntitySetup;
import com.alaharranhonor.swem.forge.tileentity.TackBoxBE;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class TackBoxBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    public static final EnumProperty<SWEMBlockStateProperties.TackBoxType> TYPE = SWEMBlockStateProperties.TACK_BOX_TYPE;
    public static final IntegerProperty COLOR = IntegerProperty.m_61631_((String)"color", (int)0, (int)15);

    public TackBoxBlock(BlockBehaviour.Properties properties, int color) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_(TYPE, (Comparable)((Object)SWEMBlockStateProperties.TackBoxType.SINGLE))).m_61124_((Property)COLOR, (Comparable)Integer.valueOf(color)));
    }

    public static Direction getConnectedDirection(BlockState blockState) {
        Direction direction = (Direction)blockState.m_61143_((Property)f_54117_);
        SWEMBlockStateProperties.TackBoxType boxType = (SWEMBlockStateProperties.TackBoxType)((Object)blockState.m_61143_(TYPE));
        if (boxType == SWEMBlockStateProperties.TackBoxType.SINGLE) {
            return null;
        }
        return boxType == SWEMBlockStateProperties.TackBoxType.LEFT ? direction.m_122427_() : direction.m_122428_();
    }

    public InteractionResult m_6227_(BlockState state, Level pLevel, BlockPos pos, Player pPlayer, InteractionHand handIn, BlockHitResult hit) {
        if (pLevel.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        ServerLevel level = (ServerLevel)pLevel;
        ServerPlayer player = (ServerPlayer)pPlayer;
        BlockPos.MutableBlockPos offsetPos = state.m_61143_(TYPE) == SWEMBlockStateProperties.TackBoxType.LEFT ? pos.m_121945_(((Direction)state.m_61143_((Property)f_54117_)).m_122427_()).m_122032_() : pos.m_121945_(((Direction)state.m_61143_((Property)f_54117_)).m_122428_()).m_122032_();
        TackBoxBE box = level.m_141902_(pos, (BlockEntityType)BlockEntitySetup.TACK_BOX_BLOCK_ENTITY.get()).filter(TackBoxBE::isBound).or(() -> TackBoxBlock.lambda$use$0(level, (BlockPos)offsetPos)).filter(TackBoxBE::isBound).orElse(null);
        if (box == null || !box.isBound()) {
            player.m_5661_((Component)Component.m_237115_((String)"text.swem.status.tack_box_not_bound"), true);
            return InteractionResult.SUCCESS;
        }
        Entity entity = level.m_8791_(box.getHorseId());
        NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)box, buffer -> {
            buffer.m_130064_(box.m_58899_());
            buffer.writeInt(entity == null ? -1 : entity.m_19879_());
            buffer.m_130083_(box.getHorseName());
        });
        return InteractionResult.CONSUME;
    }

    public List<ItemStack> m_49635_(BlockState pState, LootParams.Builder pBuilder) {
        ResourceLocation resourcelocation = this.m_60589_();
        if (resourcelocation == BuiltInLootTables.f_78712_) {
            return Collections.emptyList();
        }
        LootParams params = pBuilder.m_287286_(LootContextParams.f_81461_, (Object)pState).m_287235_(LootContextParamSets.f_81421_);
        ServerLevel serverlevel = params.m_287182_();
        LootTable loottable = serverlevel.m_7654_().m_278653_().m_278676_(resourcelocation);
        BlockEntity blockentity = (BlockEntity)pBuilder.m_287159_(LootContextParams.f_81462_);
        ObjectArrayList items = loottable.m_287195_(params);
        if (blockentity instanceof TackBoxBE) {
            TackBoxBE tack = (TackBoxBE)blockentity;
            for (ItemStack stack : items) {
                if (!(stack.m_41720_() instanceof TackBoxBlockItem)) continue;
                tack.m_187476_(stack);
            }
        }
        return items;
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, @javax.annotation.Nullable LivingEntity placer, ItemStack stack) {
        CompoundTag tag;
        if (!worldIn.f_46443_ && (tag = BlockItem.m_186336_((ItemStack)stack)) != null && tag.m_128403_("HorseId")) {
            UUID id = tag.m_128342_("HorseId");
            MutableComponent name = Component.Serializer.m_130701_((String)tag.m_128461_("HorseName"));
            BlockEntity tile = worldIn.m_7702_(pos);
            if (tile instanceof TackBoxBE) {
                TackBoxBE box = (TackBoxBE)tile;
                box.setHorseData(id, (Component)name);
            }
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return Shapes.m_83048_((double)0.05, (double)0.05, (double)0.01, (double)0.99, (double)0.75, (double)0.99);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, TYPE, COLOR});
    }

    private Direction candidatePartnerFacing(BlockPlaceContext ctx, Direction direction) {
        BlockPos candidatePos = ctx.m_8083_().m_121945_(direction);
        BlockState candidate = ctx.m_43725_().m_8055_(candidatePos);
        return ctx.m_43725_().m_141902_(candidatePos, (BlockEntityType)BlockEntitySetup.TACK_BOX_BLOCK_ENTITY.get()).map(box -> {
            CompoundTag data;
            if (box.isBound() && (data = BlockItem.m_186336_((ItemStack)ctx.m_43722_())) != null && data.m_128441_("HorseId") && !data.m_128342_("HorseId").equals(box.getHorseId())) {
                return null;
            }
            return candidate.m_60713_((Block)this) && candidate.m_61143_(TYPE) == SWEMBlockStateProperties.TackBoxType.SINGLE ? (Direction)candidate.m_61143_((Property)f_54117_) : null;
        }).orElse(null);
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        Direction candidateFacing;
        SWEMBlockStateProperties.TackBoxType tackBoxType = SWEMBlockStateProperties.TackBoxType.SINGLE;
        Direction direction = ctx.m_8125_().m_122424_();
        boolean sneaking = ctx.m_7078_();
        Direction clickedFace = ctx.m_43719_();
        if (clickedFace.m_122434_().m_122479_() && sneaking && (candidateFacing = this.candidatePartnerFacing(ctx, clickedFace.m_122424_())) != null && candidateFacing.m_122434_() != clickedFace.m_122434_()) {
            direction = candidateFacing;
            SWEMBlockStateProperties.TackBoxType tackBoxType2 = tackBoxType = candidateFacing.m_122428_() == clickedFace.m_122424_() ? SWEMBlockStateProperties.TackBoxType.RIGHT : SWEMBlockStateProperties.TackBoxType.LEFT;
        }
        if (tackBoxType == SWEMBlockStateProperties.TackBoxType.SINGLE && !sneaking) {
            if (direction == this.candidatePartnerFacing(ctx, direction.m_122427_())) {
                tackBoxType = SWEMBlockStateProperties.TackBoxType.LEFT;
            } else if (direction == this.candidatePartnerFacing(ctx, direction.m_122428_())) {
                tackBoxType = SWEMBlockStateProperties.TackBoxType.RIGHT;
            }
        }
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)direction)).m_61124_(TYPE, (Comparable)((Object)tackBoxType));
    }

    public BlockState m_7417_(BlockState state, Direction neighbourDirection, BlockState neighbourState, LevelAccessor level, BlockPos pos, BlockPos neighbourPos) {
        if (neighbourState.m_60713_((Block)this) && neighbourDirection.m_122434_().m_122479_()) {
            SWEMBlockStateProperties.TackBoxType neighbourBoxType = (SWEMBlockStateProperties.TackBoxType)((Object)neighbourState.m_61143_(TYPE));
            UUID id = TackBoxBlock.getHorseId(level, pos);
            UUID neighbourId = TackBoxBlock.getHorseId(level, neighbourPos);
            if (state.m_61143_(TYPE) == SWEMBlockStateProperties.TackBoxType.SINGLE && neighbourBoxType != SWEMBlockStateProperties.TackBoxType.SINGLE && state.m_61143_((Property)f_54117_) == neighbourState.m_61143_((Property)f_54117_) && TackBoxBlock.getConnectedDirection(neighbourState) == neighbourDirection.m_122424_() && (id == null || neighbourId == null || Objects.equals(id, neighbourId))) {
                return (BlockState)state.m_61124_(TYPE, (Comparable)((Object)neighbourBoxType.getOpposite()));
            }
        } else if (TackBoxBlock.getConnectedDirection(state) == neighbourDirection) {
            return (BlockState)state.m_61124_(TYPE, (Comparable)((Object)SWEMBlockStateProperties.TackBoxType.SINGLE));
        }
        return super.m_7417_(state, neighbourDirection, neighbourState, level, pos, neighbourPos);
    }

    private static UUID getHorseId(LevelAccessor level, BlockPos pos) {
        return level.m_141902_(pos, (BlockEntityType)BlockEntitySetup.TACK_BOX_BLOCK_ENTITY.get()).map(TackBoxBE::getHorseId).orElse(null);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos p_153215_, BlockState p_153216_) {
        return new TackBoxBE(p_153215_, p_153216_);
    }

    private static /* synthetic */ Optional lambda$use$0(ServerLevel level, BlockPos offsetPos) {
        return level.m_141902_(offsetPos, (BlockEntityType)BlockEntitySetup.TACK_BOX_BLOCK_ENTITY.get());
    }
}

