/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.blocks;

import com.alaharranhonor.swem.forge.blocks.HalfBarrelBlock;
import com.alaharranhonor.swem.forge.blocks.WallSpigotBlock;
import com.alaharranhonor.swem.forge.blocks.WaterTroughBlock;
import com.alaharranhonor.swem.forge.config.CommonConfig;
import com.alaharranhonor.swem.forge.registry.BlockSetup;
import com.alaharranhonor.swem.forge.util.SWEMUtil;
import com.alaharranhonor.swem.forge.util.SimpleCraftingContainer;
import java.util.Optional;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CauldronBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class SpigotBlock
extends HorizontalDirectionalBlock {
    protected static final VoxelShape AABB = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)12.0, (double)10.0);

    public SpigotBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH));
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        BlockPos checkPos;
        BlockState checkState;
        boolean hasWater;
        boolean bl = hasWater = (Boolean)CommonConfig.BLOCK_WATER_REQUIRED.get() == false || SWEMUtil.isInDistanceOfBlock(pLevel, pPos, 15, (Block)BlockSetup.BLOCK_O_WATER.get());
        if (!hasWater) {
            pPlayer.m_5661_((Component)Component.m_237115_((String)"text.swem.no_usable_water_nearby"), true);
            return InteractionResult.FAIL;
        }
        ItemStack held = pPlayer.m_21120_(pHand);
        Item item = held.m_41720_();
        if (item == Items.f_42446_) {
            held.m_41774_(1);
            if (held.m_41619_()) {
                pPlayer.m_21008_(pHand, new ItemStack((ItemLike)Items.f_42447_));
            } else if (!pPlayer.m_150109_().m_36054_(new ItemStack((ItemLike)Items.f_42447_))) {
                pPlayer.m_36176_(new ItemStack((ItemLike)Items.f_42447_), false);
            }
            pPlayer.m_5496_(SoundEvents.f_11781_, 1.0f, 1.0f);
            if (!pLevel.m_5776_()) {
                CriteriaTriggers.f_10576_.m_38772_((ServerPlayer)pPlayer, new ItemStack((ItemLike)Items.f_42447_));
            }
            return InteractionResult.m_19078_((boolean)pLevel.m_5776_());
        }
        if (!held.m_41619_()) {
            CraftingRecipe recipe;
            ItemStack result;
            SimpleCraftingContainer container = new SimpleCraftingContainer(new ItemStack((ItemLike)Items.f_42447_), held.m_41777_());
            Optional recipeOptional = pLevel.m_7465_().m_44015_(RecipeType.f_44107_, (Container)container, pLevel);
            if (!recipeOptional.isEmpty() && !(result = (recipe = (CraftingRecipe)recipeOptional.get()).m_5874_((Container)container, pLevel.m_9598_())).m_41619_()) {
                if (!pLevel.m_5776_()) {
                    if (!pPlayer.m_150110_().f_35937_) {
                        held.m_41774_(1);
                    }
                    if (!pPlayer.m_36356_(result)) {
                        pPlayer.m_36176_(result, true);
                    }
                }
                pPlayer.m_5496_(SoundEvents.f_11781_, 1.0f, 1.0f);
                return InteractionResult.m_19078_((boolean)pLevel.m_5776_());
            }
        }
        if ((checkState = pLevel.m_8055_(checkPos = pState.m_60734_() instanceof WallSpigotBlock ? pPos.m_7495_() : pPos.m_7495_().m_121945_((Direction)pState.m_61143_((Property)f_54117_)))).m_60734_() instanceof CauldronBlock) {
            this.triggerSplashPartices(pLevel, checkPos);
            pPlayer.m_36220_(Stats.f_12943_);
            pLevel.m_46597_(checkPos, (BlockState)Blocks.f_152476_.m_49966_().m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(3)));
            pLevel.m_5594_(null, pPos, SoundEvents.f_11778_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.m_19078_((boolean)pLevel.m_5776_());
        }
        if (checkState.m_60734_() instanceof HalfBarrelBlock) {
            int i = (Integer)checkState.m_61143_((Property)HalfBarrelBlock.LEVEL);
            if (i == 3) {
                return InteractionResult.PASS;
            }
            if (i < 3) {
                this.triggerSplashPartices(pLevel, checkPos);
                pLevel.m_46597_(checkPos, (BlockState)checkState.m_61124_((Property)HalfBarrelBlock.LEVEL, (Comparable)Integer.valueOf(Mth.m_14045_((int)3, (int)0, (int)3))));
                pLevel.m_46717_(pPos, (Block)this);
                pLevel.m_5594_(null, pPos, SoundEvents.f_11778_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            return InteractionResult.m_19078_((boolean)pLevel.m_5776_());
        }
        if (checkState.m_60734_() instanceof WaterTroughBlock) {
            if ((Integer)checkState.m_61143_((Property)WaterTroughBlock.LEVEL) == 16) {
                return InteractionResult.PASS;
            }
            WaterTroughBlock wtBlock = (WaterTroughBlock)checkState.m_60734_();
            wtBlock.setWaterLevel(pLevel, checkPos, checkState, false);
            this.triggerSplashPartices(pLevel, checkPos);
            pLevel.m_5594_(null, pPos, SoundEvents.f_11778_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.m_19078_((boolean)pLevel.m_5776_());
        }
        return super.m_6227_(pState, pLevel, pPos, pPlayer, pHand, pHit);
    }

    private void triggerSplashPartices(Level pLevel, BlockPos checkPos) {
        if (!pLevel.m_5776_()) {
            for (int j = 0; j < 6; ++j) {
                ((ServerLevel)pLevel).m_8767_((ParticleOptions)ParticleTypes.f_123769_, (double)checkPos.m_123341_() + Math.random(), (double)(checkPos.m_123342_() + 1), (double)checkPos.m_123343_() + Math.random(), 1, 0.0, 0.0, 0.0, 1.0);
            }
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return AABB;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        Direction[] adirection;
        BlockState blockstate = this.m_49966_();
        Level levelreader = pContext.m_43725_();
        BlockPos blockpos = pContext.m_8083_();
        for (Direction direction : adirection = pContext.m_6232_()) {
            Direction direction1;
            if (!direction.m_122434_().m_122479_() || !(blockstate = (BlockState)blockstate.m_61124_((Property)f_54117_, (Comparable)(direction1 = direction.m_122424_()))).m_60710_((LevelReader)levelreader, blockpos)) continue;
            return blockstate;
        }
        return null;
    }

    public BlockState m_7417_(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        return pDirection == Direction.DOWN && !this.m_7898_(pState, (LevelReader)pLevel, pCurrentPos) ? Blocks.f_50016_.m_49966_() : pState;
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        return SpigotBlock.m_49863_((LevelReader)pLevel, (BlockPos)pPos.m_7495_(), (Direction)Direction.UP);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{f_54117_});
    }
}

