/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.blocks;

import com.alaharranhonor.swem.forge.items.ShavingsItem;
import com.alaharranhonor.swem.forge.items.tools.PitchforkTool;
import com.alaharranhonor.swem.forge.registry.BlockSetup;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class Shavings
extends Block {
    public static final IntegerProperty LAYERS = BlockStateProperties.f_61417_;
    public static final VoxelShape[] SHAPES = new VoxelShape[]{Shapes.m_83040_(), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};
    private final Supplier<Set<Item>> shavingItems;

    public Shavings(BlockBehaviour.Properties properties, Supplier<Set<Item>> shavingItems) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LAYERS, (Comparable)Integer.valueOf(1)));
        this.shavingItems = shavingItems;
    }

    public boolean allowsMovement(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        switch (type) {
            case LAND: {
                return true;
            }
            case WATER: {
                return false;
            }
            case AIR: {
                return false;
            }
        }
        return false;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPES[(Integer)state.m_61143_((Property)LAYERS)];
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPES[(Integer)state.m_61143_((Property)LAYERS) - 1];
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockState blockstate = worldIn.m_8055_(pos.m_7495_());
        Block block = blockstate.m_60734_();
        if (block != Blocks.f_50126_ && block != Blocks.f_50354_ && block != Blocks.f_50375_) {
            if (block != Blocks.f_50719_ && block != Blocks.f_50135_) {
                return Block.m_49918_((VoxelShape)blockstate.m_60812_((BlockGetter)worldIn, pos.m_7495_()), (Direction)Direction.UP) || block == this && (Integer)blockstate.m_61143_((Property)LAYERS) == 8;
            }
            return true;
        }
        return false;
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        return !stateIn.m_60710_((LevelReader)worldIn, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext useContext) {
        int i = (Integer)state.m_61143_((Property)LAYERS);
        if (this.m_7374_() == BlockSetup.SOILED_SHAVINGS.get()) {
            return false;
        }
        if (this.shavingItems.get().contains(useContext.m_43722_().m_41720_()) && i < 8) {
            return useContext.m_43719_() == Direction.UP;
        }
        return i == 1;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState blockstate = context.m_43725_().m_8055_(context.m_8083_());
        if (blockstate.m_60734_() == this) {
            int i = (Integer)blockstate.m_61143_((Property)LAYERS);
            return (BlockState)blockstate.m_61124_((Property)LAYERS, (Comparable)Integer.valueOf(Math.min(8, i + 1)));
        }
        return super.m_5573_(context);
    }

    public void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{LAYERS});
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        super.m_5707_(level, pos, state, player);
        if (player.m_7500_()) {
            return;
        }
        ItemStack shavings = new ItemStack((ItemLike)state.m_60734_().m_5456_());
        int amount = (Integer)state.m_61143_((Property)LAYERS);
        if (!state.m_60713_((Block)BlockSetup.SOILED_SHAVINGS.get()) && amount == 1 && (double)player.m_217043_().m_188501_() < 0.6) {
            return;
        }
        if (player.m_21205_().m_41720_() instanceof PitchforkTool) {
            if (shavings.m_41720_() instanceof ShavingsItem.SoiledShavingsItem) {
                shavings.m_41764_(amount);
            } else {
                shavings.m_41721_(8 - amount);
            }
        } else if (shavings.m_41720_() instanceof ShavingsItem.SoiledShavingsItem) {
            shavings.m_41764_(1);
        } else {
            shavings.m_41721_(7);
        }
        ItemEntity shavingEntity = new ItemEntity(level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), shavings);
        level.m_7967_((Entity)shavingEntity);
    }
}

