/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.blocks;

import com.alaharranhonor.swem.forge.tileentity.RackBaseBE;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RackBaseBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    private final String texture;

    protected RackBaseBlock(BlockBehaviour.Properties pProperties, String texture) {
        super(pProperties);
        this.texture = texture;
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH));
    }

    public String getTexture() {
        return this.texture;
    }

    protected abstract BlockEntityType<? extends RackBaseBE> getType();

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand handIn, @NotNull BlockHitResult hit) {
        if (level.f_46443_ || handIn != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        return level.m_141902_(hit.m_82425_(), this.getType()).map(rack -> {
            if (!rack.hasOwner()) {
                rack.setOwner(player);
            }
            if (player.m_6144_() && rack.canModifyLocks(player)) {
                if (!level.m_5776_()) {
                    NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)rack, buffer -> buffer.m_130064_(rack.m_58899_()));
                }
                return InteractionResult.m_19078_((boolean)level.m_5776_());
            }
            if (!rack.canAccess(player)) {
                return InteractionResult.PASS;
            }
            ItemStack held = player.m_21120_(handIn);
            return this.handleItemInteraction(player, held, hit, rack);
        }).orElse(InteractionResult.PASS);
    }

    public Map<Direction, VoxelShape[]> getDirectionalShapes() {
        return new EnumMap<Direction, VoxelShape[]>(Direction.class);
    }

    protected <T extends RackBaseBE> InteractionResult handleItemInteraction(Player player, ItemStack held, BlockHitResult hit, T rack) {
        int slot;
        for (slot = 0; slot < rack.getInventory().getSlots() && !this.getDirectionalShapes().get(rack.m_58900_().m_61143_((Property)f_54117_))[slot].m_83215_().m_82338_(hit.m_82425_()).m_82400_(0.05).m_82390_(hit.m_82450_()); ++slot) {
        }
        return rack.handleSlottedInteraction(player, held, slot);
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, @Nullable LivingEntity pPlacer, ItemStack pStack) {
        if (!(pPlacer instanceof Player)) {
            return;
        }
        Player player = (Player)pPlacer;
        pLevel.m_141902_(pPos, this.getType()).ifPresent(rack -> rack.setOwner(player));
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pMovedByPiston) {
        pLevel.m_141902_(pPos, this.getType()).ifPresent(RackBaseBE::dropItems);
        super.m_6810_(pState, pLevel, pPos, pNewState, pMovedByPiston);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Entity entity = ((EntityCollisionContext)context).m_193113_();
        Direction facing = (Direction)state.m_61143_((Property)f_54117_);
        VoxelShape[] shapes = this.getDirectionalShapes().get(facing);
        if (entity != null && shapes != null) {
            return worldIn.m_141902_(pos, this.getType()).map(rack -> {
                VoxelShape closest = Shapes.m_83040_();
                double closestDistance = Double.MAX_VALUE;
                for (int slot = 0; slot < rack.getInventory().getSlots(); ++slot) {
                    double distance;
                    VoxelShape shape = shapes[slot];
                    BlockHitResult hit = shape.m_83220_(entity.m_146892_(), entity.m_146892_().m_82549_(entity.m_20154_().m_82490_(5.0)), pos);
                    if (hit == null || !((distance = entity.m_146892_().m_82554_(hit.m_82450_())) < closestDistance)) continue;
                    closest = shape;
                    closestDistance = distance;
                }
                return closest;
            }).orElse(Shapes.m_83040_());
        }
        return Shapes.m_83124_((VoxelShape)Shapes.m_83040_(), (VoxelShape[])shapes);
    }

    @javax.annotation.Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction facing = context.m_43719_().m_122434_().m_122478_() ? context.m_8125_().m_122424_() : context.m_43719_();
        return (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)facing);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_});
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public static Map<Direction, VoxelShape[]> generateDirectionalShapes(final VoxelShape[] northShapes) {
        return new HashMap<Direction, VoxelShape[]>(){
            {
                this.put(Direction.NORTH, northShapes);
                this.put(Direction.EAST, 1.generateShapes(northShapes, Direction.EAST));
                this.put(Direction.SOUTH, 1.generateShapes(northShapes, Direction.SOUTH));
                this.put(Direction.WEST, 1.generateShapes(northShapes, Direction.WEST));
            }

            private static VoxelShape generateShape(VoxelShape northShape, Direction direction) {
                double minX = northShape.m_83288_(Direction.Axis.X);
                double minY = northShape.m_83288_(Direction.Axis.Y);
                double minZ = northShape.m_83288_(Direction.Axis.Z);
                double maxX = northShape.m_83297_(Direction.Axis.X);
                double maxY = northShape.m_83297_(Direction.Axis.Y);
                double maxZ = northShape.m_83297_(Direction.Axis.Z);
                return switch (direction) {
                    case Direction.EAST -> Shapes.m_83048_((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX);
                    case Direction.SOUTH -> Shapes.m_83048_((double)(1.0 - maxX), (double)minY, (double)(1.0 - maxZ), (double)(1.0 - minX), (double)maxY, (double)(1.0 - minZ));
                    case Direction.WEST -> Shapes.m_83048_((double)minZ, (double)minY, (double)(1.0 - maxX), (double)maxZ, (double)maxY, (double)(1.0 - minX));
                    default -> northShape;
                };
            }

            private static VoxelShape[] generateShapes(VoxelShape[] northShapes2, Direction direction) {
                VoxelShape[] generated = new VoxelShape[northShapes2.length];
                for (int i = 0; i < northShapes2.length; ++i) {
                    generated[i] = 1.generateShape(northShapes2[i], direction);
                }
                return generated;
            }
        };
    }
}

