/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.blocks;

import com.alaharranhonor.swem.forge.registry.BlockEntitySetup;
import com.alaharranhonor.swem.forge.tileentity.LockerBE;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class LockerBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    public LockerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH));
    }

    public boolean canEntityDestroy(BlockState state, BlockGetter level, BlockPos pos, Entity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return level.m_141902_(pos, (BlockEntityType)BlockEntitySetup.LOCKER_BLOCK_ENTITY.get()).map(locker -> locker.canModifyLock(player)).orElse(false);
        }
        return super.canEntityDestroy(state, level, pos, entity);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        BlockEntity tile = level.m_7702_(pos);
        if (!(tile instanceof LockerBE)) {
            return InteractionResult.FAIL;
        }
        LockerBE locker = (LockerBE)tile;
        if (level.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        if (!locker.hasOwner()) {
            locker.initializeWithOwner(player);
        }
        boolean leftHit = this.determineHitVec(hit.m_82450_(), state, pos);
        locker.setLeftSideOpened(leftHit);
        if (!locker.m_7525_(player)) {
            player.m_5661_((Component)Component.m_237115_((String)"locker.cannot_open").m_130940_(ChatFormatting.RED), true);
            return InteractionResult.FAIL;
        }
        NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)((LockerBE)tile), buffer -> {
            buffer.m_130064_(pos);
            buffer.writeBoolean(leftHit);
        });
        return InteractionResult.CONSUME;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack pStack) {
        if (!(placer instanceof Player)) {
            return;
        }
        Player player = (Player)placer;
        level.m_141902_(pos, (BlockEntityType)BlockEntitySetup.LOCKER_BLOCK_ENTITY.get()).ifPresent(locker -> locker.initializeWithOwner(player));
    }

    private boolean determineHitVec(Vec3 hitVec, BlockState state, BlockPos pos) {
        switch ((Direction)state.m_61143_((Property)f_54117_)) {
            case EAST: {
                return !(hitVec.f_82481_ > (double)pos.m_123343_() + 0.5);
            }
            case WEST: {
                return !(hitVec.f_82481_ < (double)pos.m_123343_() + 0.5);
            }
            case NORTH: {
                return !(hitVec.f_82479_ > (double)pos.m_123341_() + 0.5);
            }
            case SOUTH: {
                return !(hitVec.f_82479_ < (double)pos.m_123341_() + 0.5);
            }
        }
        return true;
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity te;
        if (state.m_60734_() != newState.m_60734_() && (te = worldIn.m_7702_(pos)) instanceof LockerBE) {
            Containers.m_19010_((Level)worldIn, (BlockPos)pos, ((LockerBE)te).m_7086_());
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        switch ((Direction)state.m_61143_((Property)f_54117_)) {
            case NORTH: {
                return Shapes.m_83048_((double)0.01, (double)0.01, (double)0.01, (double)0.99, (double)0.99, (double)0.5);
            }
            case EAST: {
                return Shapes.m_83048_((double)0.5, (double)0.01, (double)0.01, (double)0.99, (double)0.99, (double)0.99);
            }
            case SOUTH: {
                return Shapes.m_83048_((double)0.01, (double)0.01, (double)0.5, (double)0.99, (double)0.99, (double)0.99);
            }
            case WEST: {
                return Shapes.m_83048_((double)0.01, (double)0.01, (double)0.01, (double)0.5, (double)0.99, (double)0.99);
            }
        }
        return Shapes.m_83048_((double)0.01, (double)0.01, (double)0.01, (double)0.99, (double)0.99, (double)0.99);
    }

    @javax.annotation.Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)context.m_8125_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos p_153215_, BlockState p_153216_) {
        return new LockerBE(p_153215_, p_153216_);
    }
}

