/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.common.items;

import com.direwolf20.buildinggadgets2.api.gadgets.GadgetTarget;
import com.direwolf20.buildinggadgets2.common.blocks.RenderBlock;
import com.direwolf20.buildinggadgets2.common.items.BaseGadget;
import com.direwolf20.buildinggadgets2.setup.Config;
import com.direwolf20.buildinggadgets2.util.BuildingUtils;
import com.direwolf20.buildinggadgets2.util.GadgetNBT;
import com.direwolf20.buildinggadgets2.util.GadgetUtils;
import com.direwolf20.buildinggadgets2.util.Styles;
import com.direwolf20.buildinggadgets2.util.context.ItemActionContext;
import com.direwolf20.buildinggadgets2.util.datatypes.StatePos;
import com.direwolf20.buildinggadgets2.util.modes.BaseMode;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GadgetBuilding
extends BaseGadget {
    @Override
    public int getEnergyMax() {
        return (Integer)Config.BUILDINGGADGET_MAXPOWER.get();
    }

    @Override
    public int getEnergyCost() {
        return (Integer)Config.BUILDINGGADGET_COST.get();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        Minecraft mc = Minecraft.m_91087_();
        if (level == null || mc.f_91074_ == null) {
            return;
        }
        boolean sneakPressed = Screen.m_96638_();
        if (sneakPressed) {
            BaseMode mode = GadgetNBT.getMode(stack);
            tooltip.add((Component)Component.m_237110_((String)"buildinggadgets2.tooltips.mode", (Object[])new Object[]{Component.m_237115_((String)mode.i18n())}).m_6270_(Styles.AQUA));
            tooltip.add((Component)Component.m_237110_((String)"buildinggadgets2.tooltips.range", (Object[])new Object[]{GadgetNBT.getToolRange(stack)}).m_6270_(Styles.LT_PURPLE));
            tooltip.add((Component)Component.m_237110_((String)"buildinggadgets2.tooltips.blockstate", (Object[])new Object[]{GadgetNBT.getGadgetBlockState(stack).m_60734_().m_49954_()}).m_6270_(Styles.DK_GREEN));
        }
    }

    @Override
    InteractionResultHolder<ItemStack> onAction(ItemActionContext context) {
        ItemStack gadget = context.stack();
        BlockState setState = GadgetNBT.getGadgetBlockState(gadget);
        if (setState.m_60795_()) {
            return InteractionResultHolder.m_19098_((Object)gadget);
        }
        BaseMode mode = GadgetNBT.getMode(gadget);
        ArrayList<StatePos> buildList = mode.collect(context.hitResult().m_82434_(), context.player(), GadgetBuilding.getHitPos(context), setState);
        UUID buildUUID = BuildingUtils.build(context.level(), context.player(), buildList, GadgetBuilding.getHitPos(context), gadget, true);
        GadgetUtils.addToUndoList(context.level(), gadget, new ArrayList<StatePos>(), buildUUID);
        GadgetNBT.clearAnchorPos(gadget);
        return InteractionResultHolder.m_19090_((Object)gadget);
    }

    @Override
    InteractionResultHolder<ItemStack> onShiftAction(ItemActionContext context) {
        BlockState blockState = context.level().m_8055_(context.pos());
        if (!GadgetUtils.isValidBlockState(blockState, context.level(), context.pos()) || blockState.m_60734_() instanceof RenderBlock) {
            context.player().m_5661_((Component)Component.m_237115_((String)"buildinggadgets2.messages.invalidblock"), true);
            return super.onShiftAction(context);
        }
        if (GadgetUtils.setBlockState(context.stack(), blockState)) {
            return InteractionResultHolder.m_19090_((Object)context.stack());
        }
        return super.onShiftAction(context);
    }

    @Override
    public GadgetTarget gadgetTarget() {
        return GadgetTarget.BUILDING;
    }
}

