/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.datagen.provider.tag;

import com.google.common.base.Preconditions;
import it.zerono.mods.zerocore.lib.datagen.provider.tag.ModTagAppender;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagBuilder;
import net.minecraft.tags.TagKey;
import net.minecraftforge.common.util.NonNullFunction;

public class ModIntrinsicTagAppender<T>
extends ModTagAppender<T> {
    private final NonNullFunction<T, ResourceKey<T>> _keyProvider;

    public ModIntrinsicTagAppender(TagBuilder builder, NonNullFunction<T, ResourceKey<T>> keyProvider) {
        super(builder);
        Preconditions.checkNotNull(keyProvider, (Object)"Key provider must not be null");
        this._keyProvider = keyProvider;
    }

    public ModIntrinsicTagAppender<T> add(T element) {
        return this.add((ResourceKey)this._keyProvider.apply(element));
    }

    @SafeVarargs
    public final ModIntrinsicTagAppender<T> add(T ... elements) {
        for (T element : elements) {
            this.add(element);
        }
        return this;
    }

    @Override
    public ModIntrinsicTagAppender<T> add(Supplier<? extends T> element) {
        return this.add(element.get());
    }

    @SafeVarargs
    public final ModIntrinsicTagAppender<T> add(Supplier<? extends T> ... elements) {
        for (Supplier<? extends T> element : elements) {
            this.add(element);
        }
        return this;
    }

    @Override
    public ModIntrinsicTagAppender<T> add(ResourceKey<T> element) {
        super.add(element);
        return this;
    }

    @Override
    public ModIntrinsicTagAppender<T> addOptional(ResourceLocation optionalElement) {
        super.addOptional(optionalElement);
        return this;
    }

    @Override
    public ModTagAppender<T> addTag(TagKey<T> tag) {
        super.addTag(tag);
        return this;
    }

    @Override
    public ModTagAppender<T> addOptionalTag(ResourceLocation optionalTag) {
        super.addOptionalTag(optionalTag);
        return this;
    }
}

