/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.datagen.provider.client.state;

import com.google.common.base.Preconditions;
import it.zerono.mods.zerocore.lib.datagen.provider.client.model.ModelBuilder;
import it.zerono.mods.zerocore.lib.datagen.provider.client.state.ModelVariantsList;
import net.minecraft.data.models.blockstates.Variant;
import net.minecraft.data.models.blockstates.VariantProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.common.util.NonNullFunction;

public class ModelVariantBuilder {
    private final ModelVariantsList _sink;
    private final ModelBuilder _modelBuilder;
    private Variant _variant;
    private boolean _built;

    static void build(ModelVariantsList sink, ModelBuilder modelBuilder, NonNullConsumer<ModelVariantBuilder> variantsBuilder) {
        Preconditions.checkNotNull((Object)sink, (Object)"Sink must not be null");
        Preconditions.checkNotNull((Object)modelBuilder, (Object)"Model builder must not be null");
        Preconditions.checkNotNull(variantsBuilder, (Object)"Variant builder must not be null");
        ModelVariantBuilder builder = new ModelVariantBuilder(sink, modelBuilder);
        variantsBuilder.accept((Object)builder);
        if (!builder.isBuilt()) {
            builder.build();
        }
    }

    private ModelVariantBuilder(ModelVariantsList sink, ModelBuilder modelBuilder) {
        this._sink = sink;
        this._modelBuilder = modelBuilder;
        this._variant = Variant.m_125501_();
        this._built = false;
    }

    public ModelVariantBuilder build() {
        this._sink.add(this._variant);
        this._variant = Variant.m_125501_();
        this._built = true;
        return this;
    }

    boolean isBuilt() {
        return this._built;
    }

    public ModelVariantBuilder merge(Variant variant) {
        Preconditions.checkNotNull((Object)variant, (Object)"Variant must not be null");
        this._variant = Variant.m_125508_((Variant)this._variant, (Variant)variant);
        this._built = false;
        return this;
    }

    public ModelVariantBuilder model(ResourceLocation model) {
        Preconditions.checkNotNull((Object)model, (Object)"Model must not be null");
        this._variant.m_125511_(VariantProperties.f_125520_, (Object)model);
        this._built = false;
        return this;
    }

    public ModelVariantBuilder model(NonNullFunction<ModelBuilder, ResourceLocation> builder) {
        Preconditions.checkNotNull(builder, (Object)"Builder must not be null");
        ResourceLocation blockModel = (ResourceLocation)builder.apply((Object)this._modelBuilder);
        return this.model(blockModel);
    }

    public ModelVariantBuilder xRotation(VariantProperties.Rotation rotation) {
        Preconditions.checkNotNull((Object)rotation, (Object)"Rotation must not be null");
        this._variant.m_125511_(VariantProperties.f_125518_, (Object)rotation);
        this._built = false;
        return this;
    }

    public ModelVariantBuilder xRotation(int rotation) {
        Preconditions.checkArgument((0 == rotation || 90 == rotation || 180 == rotation || 270 == rotation ? 1 : 0) != 0, (Object)"Rotation can only be 0, 90, 180 or 270");
        return this.xRotation(VariantProperties.Rotation.valueOf((String)("R" + rotation)));
    }

    public ModelVariantBuilder yRotation(VariantProperties.Rotation rotation) {
        Preconditions.checkNotNull((Object)rotation, (Object)"Rotation must not be null");
        this._variant.m_125511_(VariantProperties.f_125519_, (Object)rotation);
        this._built = false;
        return this;
    }

    public ModelVariantBuilder yRotation(int rotation) {
        Preconditions.checkArgument((0 == rotation || 90 == rotation || 180 == rotation || 270 == rotation ? 1 : 0) != 0, (Object)"Rotation can only be 0, 90, 180 or 270");
        return this.yRotation(VariantProperties.Rotation.valueOf((String)("R" + rotation)));
    }

    public ModelVariantBuilder uvLock() {
        return this.uvLock(true);
    }

    public ModelVariantBuilder uvLock(boolean enabled) {
        this._variant.m_125511_(VariantProperties.f_125521_, (Object)enabled);
        this._built = false;
        return this;
    }

    public ModelVariantBuilder weight(int weight) {
        Preconditions.checkArgument((weight >= 1 ? 1 : 0) != 0, (Object)"Weight must be greater than or equal to one.");
        this._variant.m_125511_(VariantProperties.f_125522_, (Object)weight);
        this._built = false;
        return this;
    }
}

