/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.data;

import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.data.EnumIndexer;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public class EnumIndexedArray<Index extends Enum<Index>, Element>
extends EnumIndexer<Index> {
    private final Element[] _elements;

    @SafeVarargs
    public EnumIndexedArray(Function<Integer, Element[]> arrayFactory, Index firstValidIndex, Index secondValidIndex, Index ... otherValidIndices) {
        super(firstValidIndex, secondValidIndex, otherValidIndices);
        this._elements = arrayFactory.apply(this.validIndicesCount());
    }

    public EnumIndexedArray(Function<Integer, Element[]> arrayFactory, Index validIndex) {
        super(validIndex);
        this._elements = arrayFactory.apply(this.validIndicesCount());
    }

    public EnumIndexedArray(Function<Integer, Element[]> arrayFactory, Index[] validIndices) {
        super(validIndices);
        this._elements = arrayFactory.apply(this.validIndicesCount());
    }

    public EnumIndexedArray(Function<Integer, Element[]> arrayFactory, Iterable<Index> validIndices) {
        super(validIndices);
        this._elements = arrayFactory.apply(this.validIndicesCount());
    }

    public Optional<Element> getElement(Index type) {
        return Optional.ofNullable(this._elements[this.getOrdinal(type)]);
    }

    public Element getElement(Index type, Element defaultValue) {
        return this.getElement(type).orElse(defaultValue);
    }

    public <T> T map(Index type, Function<Element, T> mapper, T defaultValue) {
        Element e = this._elements[this.getOrdinal(type)];
        return null != e ? mapper.apply(e) : defaultValue;
    }

    public void accept(Index type, Consumer<Element> consumer) {
        Element e = this._elements[this.getOrdinal(type)];
        if (null != e) {
            consumer.accept(e);
        }
    }

    public void setElement(Index type, @Nullable Element element) {
        this._elements[this.getOrdinal(type)] = element;
    }

    public void setAll(@Nullable Element element) {
        Arrays.fill(this._elements, element);
    }

    public boolean isEmpty(Index type) {
        return null == this._elements[this.getOrdinal(type)];
    }

    public Stream<Element> stream() {
        return this.getValidIndices().stream().flatMap(index -> CodeHelper.optionalStream(this.getElement(index)));
    }

    public Stream<Element> stream(Predicate<Index> test) {
        return this.getValidIndices().stream().filter(test).flatMap(index -> CodeHelper.optionalStream(this.getElement(index)));
    }

    @Override
    public String toString() {
        return this.getValidIndices().stream().map(index -> String.format("%s:%s", index.toString(), this.getElement(index).map(Object::toString).orElse("<EMPTY>"))).collect(Collectors.joining(", ", "[", "]"));
    }
}

