/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.tempad.common.network.messages.c2s;

import com.teamresourceful.resourcefullib.common.networking.base.Packet;
import com.teamresourceful.resourcefullib.common.networking.base.PacketContext;
import com.teamresourceful.resourcefullib.common.networking.base.PacketHandler;
import com.teamresourceful.resourcefullib.common.utils.CommonUtils;
import java.util.UUID;
import me.codexadrian.tempad.common.data.LocationData;
import me.codexadrian.tempad.common.data.TempadLocationHandler;
import me.codexadrian.tempad.common.utils.TeleportUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public record AddLocationPacket(String name) implements Packet<AddLocationPacket>
{
    public static Handler HANDLER = new Handler();
    public static final ResourceLocation ID = new ResourceLocation("tempad", "add_location");

    public ResourceLocation getID() {
        return ID;
    }

    public PacketHandler<AddLocationPacket> getHandler() {
        return HANDLER;
    }

    private static class Handler
    implements PacketHandler<AddLocationPacket> {
        private Handler() {
        }

        public void encode(AddLocationPacket message, FriendlyByteBuf buffer) {
            buffer.m_130070_(message.name);
        }

        public AddLocationPacket decode(FriendlyByteBuf buffer) {
            return new AddLocationPacket(buffer.m_130277_());
        }

        public PacketContext handle(AddLocationPacket message) {
            return (player, level) -> {
                if (!TeleportUtils.hasTempad(player)) {
                    return;
                }
                UUID uuid = (UUID)CommonUtils.generate(id -> !TempadLocationHandler.containsLocation(level, player.m_20148_(), id), UUID::randomUUID);
                LocationData tempadLocation = new LocationData(message.name, (ResourceKey<Level>)player.m_9236_().m_46472_(), BlockPos.m_274561_((double)player.m_20185_(), (double)Math.ceil(player.m_20186_()), (double)player.m_20189_()), uuid);
                TempadLocationHandler.addLocation(level, player.m_20148_(), tempadLocation);
            };
        }
    }
}

