/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.tempad.common.compat.botarium.options;

import earth.terrarium.botarium.common.energy.EnergyApi;
import earth.terrarium.botarium.common.energy.base.EnergyContainer;
import earth.terrarium.botarium.common.item.ItemStackHolder;
import java.util.List;
import me.codexadrian.tempad.api.options.TempadOption;
import me.codexadrian.tempad.api.options.TempadOptionApi;
import me.codexadrian.tempad.common.utils.TeleportUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class EnergyOption
extends TempadOption {
    @Override
    public boolean canTimedoorOpen(Player player, ItemStack stack) {
        EnergyContainer energyStorage = EnergyApi.getItemEnergyContainer((ItemStackHolder)new ItemStackHolder(stack));
        if (energyStorage == null) {
            return false;
        }
        return energyStorage.getStoredEnergy() >= (long)TempadOptionApi.getFuelCost(stack);
    }

    @Override
    public void addToolTip(ItemStack stack, Level level, List<Component> components, TooltipFlag flag) {
        EnergyContainer energyStorage = EnergyApi.getItemEnergyContainer((ItemStackHolder)new ItemStackHolder(stack));
        if (energyStorage == null) {
            return;
        }
        components.add((Component)Component.m_237110_((String)"tempad_option.tempad.energy", (Object[])new Object[]{energyStorage.getStoredEnergy(), energyStorage.getMaxCapacity()}).m_130940_(ChatFormatting.GRAY));
        components.add((Component)Component.m_237110_((String)"tempad_option.tempad.energy_cost", (Object[])new Object[]{TempadOptionApi.getFuelCost(stack)}).m_130940_(ChatFormatting.GRAY));
    }

    @Override
    public void onTimedoorOpen(Player player) {
        ItemStack itemStack = TeleportUtils.findTempad(player);
        ItemStackHolder holder = new ItemStackHolder(itemStack);
        EnergyContainer energyStorage = EnergyApi.getItemEnergyContainer((ItemStackHolder)holder);
        if (energyStorage == null) {
            return;
        }
        energyStorage.internalExtract((long)TempadOptionApi.getFuelCost(itemStack), false);
        if (holder.isDirty()) {
            TeleportUtils.findAndReplaceTempad(player, holder.getStack());
        }
    }

    @Override
    public boolean isDurabilityBarVisible(ItemStack stack) {
        return true;
    }

    @Override
    public double getPercentage(ItemStack stack) {
        EnergyContainer energyStorage = EnergyApi.getItemEnergyContainer((ItemStackHolder)new ItemStackHolder(stack));
        if (energyStorage == null) {
            return 0.0;
        }
        return (double)energyStorage.getStoredEnergy() / (double)energyStorage.getMaxCapacity();
    }
}

