/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.tileentities;

import com.ldtteam.structurize.api.util.IRotatableBlockEntity;
import com.ldtteam.structurize.blockentities.interfaces.IBlueprintDataProviderBE;
import com.minecolonies.api.tileentities.MinecoloniesTileEntities;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.core.util.BuildingUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class TileEntityDecorationController
extends BlockEntity
implements IBlueprintDataProviderBE,
IRotatableBlockEntity {
    private String schematicName = "";
    private String schematicPath = "";
    private String packName = "";
    private BlockPos corner1 = BlockPos.f_121853_;
    private BlockPos corner2 = BlockPos.f_121853_;
    private int cachedRotation = -1;
    private boolean isMirrored = false;
    private Map<BlockPos, List<String>> tagPosMap = new HashMap<BlockPos, List<String>>();

    public TileEntityDecorationController(BlockPos pos, BlockState state) {
        super((BlockEntityType)MinecoloniesTileEntities.DECO_CONTROLLER.get(), pos, state);
    }

    public String getPackName() {
        return this.packName;
    }

    public String getBlueprintPath() {
        return this.schematicPath;
    }

    public String getSchematicName() {
        return this.schematicName;
    }

    public void setSchematicName(String s) {
        this.schematicName = s;
        this.m_6596_();
    }

    private void update() {
        this.m_6596_();
    }

    public void m_6596_() {
        if (this.f_58857_ != null) {
            WorldUtil.markChunkDirty(this.f_58857_, this.f_58858_);
        }
    }

    public Map<BlockPos, List<String>> getPositionedTags() {
        return this.tagPosMap;
    }

    public void setPositionedTags(Map<BlockPos, List<String>> positionedTags) {
        this.tagPosMap = positionedTags;
        this.m_6596_();
    }

    public Tuple<BlockPos, BlockPos> getSchematicCorners() {
        if (this.corner1 == BlockPos.f_121853_ || this.corner2 == BlockPos.f_121853_) {
            return new Tuple((Object)this.f_58858_, (Object)this.f_58858_);
        }
        return new Tuple((Object)this.corner1, (Object)this.corner2);
    }

    public void setSchematicCorners(BlockPos pos1, BlockPos pos2) {
        this.corner1 = pos1;
        this.corner2 = pos2;
        this.m_6596_();
    }

    public void readSchematicDataFromNBT(CompoundTag compound) {
        super.readSchematicDataFromNBT(compound);
        CompoundTag blueprintDataProvider = compound.m_128469_("blueprintDataProvider");
        this.packName = blueprintDataProvider.m_128461_("pack");
        this.schematicPath = blueprintDataProvider.m_128461_("path");
    }

    public void m_142466_(@NotNull CompoundTag compound) {
        super.m_142466_(compound);
        super.readSchematicDataFromNBT(compound);
        this.cachedRotation = -1;
        this.isMirrored = compound.m_128471_("mirror");
        this.packName = compound.m_128469_("blueprintDataProvider").m_128461_("pack");
        this.schematicPath = compound.m_128469_("blueprintDataProvider").m_128461_("path");
        if (compound.m_128441_("path") && StringUtils.isEmpty((CharSequence)this.schematicPath)) {
            this.schematicPath = compound.m_128461_("path");
        }
        if (compound.m_128441_("pack") && StringUtils.isEmpty((CharSequence)this.packName)) {
            this.packName = compound.m_128461_("pack");
        }
        if (compound.m_128441_("name") && StringUtils.isEmpty((CharSequence)this.schematicName)) {
            this.schematicName = compound.m_128461_("name");
            if (this.schematicPath == null || this.schematicPath.isEmpty()) {
                this.schematicPath = this.schematicName;
                this.schematicName = "";
            }
        }
        if (!this.schematicPath.endsWith(".blueprint")) {
            this.schematicPath = this.schematicPath + ".blueprint";
        }
    }

    public void m_183515_(@NotNull CompoundTag compound) {
        super.m_183515_(compound);
        this.writeSchematicDataToNBT(compound);
        compound.m_128379_("mirror", this.isMirrored);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void setBlueprintPath(String filePath) {
        this.schematicPath = filePath;
        if (!this.schematicPath.endsWith(".blueprint")) {
            this.schematicPath = this.schematicPath + ".blueprint";
        }
        this.m_6596_();
    }

    public void setPackName(String packName) {
        this.packName = packName;
        this.m_6596_();
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187481_();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        CompoundTag compound = packet.m_131708_();
        this.m_142466_(compound);
    }

    public BlockPos getTilePos() {
        return this.f_58858_;
    }

    public void rotate(Rotation rotationIn) {
        this.cachedRotation = -1;
    }

    public void mirror(Mirror mirror) {
        this.isMirrored = mirror != Mirror.NONE;
    }

    public Rotation getRotation() {
        if (this.cachedRotation == -1) {
            this.cachedRotation = BuildingUtils.getRotationFromBlueprint(this.m_58904_(), this.m_58899_());
        }
        return BlockPosUtil.getRotationFromRotations(this.cachedRotation);
    }

    public boolean getMirror() {
        return this.isMirrored;
    }
}

