/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.quests.triggers;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.quests.IQuestTriggerTemplate;
import com.minecolonies.api.quests.ITriggerReturnData;
import com.minecolonies.core.quests.triggers.BooleanTriggerReturnData;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class StateQuestTriggerTemplate
implements IQuestTriggerTemplate {
    public final List<String> nbtPath;
    public final JsonElement matchTag;
    public final int matchCount;

    public StateQuestTriggerTemplate(String[] paths, JsonElement match, int count) {
        this.nbtPath = List.of(paths);
        this.matchTag = match;
        this.matchCount = count;
    }

    public static StateQuestTriggerTemplate createStateTrigger(JsonObject questTriggerJson) {
        JsonObject subObj = questTriggerJson.get("state").getAsJsonObject();
        return new StateQuestTriggerTemplate(subObj.get("path").getAsString().split("/"), subObj.get("match"), subObj.has("count") ? subObj.get("count").getAsInt() : 1);
    }

    @Override
    public ITriggerReturnData canTriggerQuest(IColony colony) {
        CompoundTag subPathCompound = colony.getColonyTag();
        for (String subPath : this.nbtPath) {
            if (subPathCompound instanceof CompoundTag && subPathCompound.m_128441_(subPath)) {
                subPathCompound = subPathCompound.m_128423_(subPath);
                continue;
            }
            return new BooleanTriggerReturnData(false);
        }
        if (subPathCompound == null) {
            return new BooleanTriggerReturnData(false);
        }
        return new BooleanTriggerReturnData(IQuestTriggerTemplate.matchNbt((Tag)subPathCompound, this.matchTag, this.matchCount));
    }
}

