/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.placementhandlers;

import com.ldtteam.domumornamentum.block.decorative.PillarBlock;
import com.ldtteam.structurize.api.util.ItemStackUtils;
import com.ldtteam.structurize.placement.handlers.placement.IPlacementHandler;
import com.ldtteam.structurize.placement.handlers.placement.PlacementHandlers;
import com.ldtteam.structurize.util.BlockUtils;
import com.ldtteam.structurize.util.PlacementSettings;
import com.minecolonies.api.compatibility.candb.ChiselAndBitsCheck;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.WorldUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GeneralBlockPlacementHandler
implements IPlacementHandler {
    public boolean canHandle(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState blockState) {
        return true;
    }

    public IPlacementHandler.ActionProcessingResult handle(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete, BlockPos centerPos, PlacementSettings settings) {
        BlockState placementState = blockState;
        if (blockState.m_60734_() instanceof WallBlock || blockState.m_60734_() instanceof FenceBlock || blockState.m_60734_() instanceof PillarBlock || blockState.m_60734_() instanceof IronBarsBlock) {
            try {
                BlockState tempState = blockState.m_60734_().m_5573_(new BlockPlaceContext(world, null, InteractionHand.MAIN_HAND, ItemStack.f_41583_, new BlockHitResult(new Vec3(0.0, 0.0, 0.0), Direction.DOWN, pos, true)));
                if (tempState != null) {
                    placementState = tempState;
                }
            }
            catch (Exception tempState) {
                // empty catch block
            }
        }
        if (world.m_8055_(pos).equals(placementState)) {
            return IPlacementHandler.ActionProcessingResult.PASS;
        }
        if (!WorldUtil.setBlockState((LevelAccessor)world, pos, placementState, 3)) {
            return IPlacementHandler.ActionProcessingResult.PASS;
        }
        if (tileEntityData != null) {
            try {
                PlacementHandlers.handleTileEntityPlacement((CompoundTag)tileEntityData, (Level)world, (BlockPos)pos, (PlacementSettings)settings);
                placementState.m_60734_().m_6402_(world, pos, placementState, null, BlockUtils.getItemStackFromBlockState((BlockState)placementState));
            }
            catch (Exception ex) {
                Log.getLogger().warn("Unable to place TileEntity");
            }
        }
        return IPlacementHandler.ActionProcessingResult.SUCCESS;
    }

    public List<ItemStack> getRequiredItems(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete) {
        ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
        if (!ChiselAndBitsCheck.isChiselAndBitsBlock(blockState)) {
            itemList.add(BlockUtils.getItemStackFromBlockState((BlockState)blockState));
        }
        if (tileEntityData != null) {
            itemList.addAll(ItemStackUtils.getItemStacksOfTileEntity((CompoundTag)tileEntityData, (BlockState)blockState));
        }
        itemList.removeIf(ItemStackUtils::isEmpty);
        return itemList;
    }

    public IPlacementHandler.ActionProcessingResult handle(Level world, BlockPos pos, BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete, BlockPos centerPos) {
        Log.getLogger().warn("Using nonimplemented general placemant handling! Only with context", (Throwable)new Exception());
        return IPlacementHandler.ActionProcessingResult.PASS;
    }
}

