/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server.colony.building.home;

import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.core.colony.buildings.DefaultBuildingInstance;
import com.minecolonies.core.colony.buildings.modules.AbstractAssignedCitizenModule;
import com.minecolonies.core.colony.buildings.modules.LivingBuildingModule;
import com.minecolonies.core.colony.buildings.modules.WorkerBuildingModule;
import com.minecolonies.core.network.messages.server.AbstractBuildingServerMessage;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;

public class AssignUnassignMessage
extends AbstractBuildingServerMessage<DefaultBuildingInstance> {
    private boolean assign;
    private int citizenID;
    private JobEntry jobEntry;

    public AssignUnassignMessage() {
    }

    public AssignUnassignMessage(@NotNull IBuildingView building, boolean assign, int citizenID, JobEntry entry) {
        super(building);
        this.assign = assign;
        this.citizenID = citizenID;
        this.jobEntry = entry;
    }

    @Override
    public void fromBytesOverride(@NotNull FriendlyByteBuf buf) {
        this.assign = buf.readBoolean();
        this.citizenID = buf.readInt();
        if (buf.readBoolean()) {
            this.jobEntry = (JobEntry)buf.readRegistryId();
        }
    }

    @Override
    public void toBytesOverride(@NotNull FriendlyByteBuf buf) {
        buf.writeBoolean(this.assign);
        buf.writeInt(this.citizenID);
        if (this.jobEntry == null) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            buf.writeRegistryId(IMinecoloniesAPI.getInstance().getJobRegistry(), (Object)this.jobEntry);
        }
    }

    @Override
    public boolean errorIfCastFails() {
        return false;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony, DefaultBuildingInstance building) {
        ICitizenData citizen = colony.getCitizenManager().getCivilian(this.citizenID);
        AbstractAssignedCitizenModule module = this.jobEntry == null ? (AbstractAssignedCitizenModule)building.getFirstModuleOccurance(LivingBuildingModule.class) : (AbstractAssignedCitizenModule)building.getModuleMatching(WorkerBuildingModule.class, m -> m.getJobEntry() == this.jobEntry);
        if (this.assign && !module.isFull() && !building.equals(citizen.getHomeBuilding())) {
            if (citizen.getHomeBuilding() != null) {
                ((LivingBuildingModule)citizen.getHomeBuilding().getFirstModuleOccurance(LivingBuildingModule.class)).removeCitizen(citizen);
            }
            module.assignCitizen(citizen);
        } else if (module.hasAssignedCitizen(citizen)) {
            module.removeCitizen(citizen);
        }
    }
}

