/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server.colony.building;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import com.minecolonies.api.colony.buildings.modules.settings.ISetting;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingKey;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.core.colony.buildings.AbstractBuilding;
import com.minecolonies.core.colony.buildings.modules.SettingsModule;
import com.minecolonies.core.colony.buildings.modules.settings.SettingKey;
import com.minecolonies.core.network.messages.server.AbstractBuildingServerMessage;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;

public class TriggerSettingMessage
extends AbstractBuildingServerMessage<AbstractBuilding> {
    private ResourceLocation key;
    private ISetting value;
    private int moduleID;

    public TriggerSettingMessage() {
    }

    public TriggerSettingMessage(IBuildingView building, ISettingKey<?> key, ISetting value, int moduleID) {
        super(building);
        this.key = key.getUniqueId();
        this.value = value;
        this.moduleID = moduleID;
    }

    @Override
    public void fromBytesOverride(@NotNull FriendlyByteBuf buf) {
        this.moduleID = buf.readInt();
        this.key = buf.m_130281_();
        this.value = (ISetting)StandardFactoryController.getInstance().deserialize(buf);
    }

    @Override
    public void toBytesOverride(@NotNull FriendlyByteBuf buf) {
        buf.writeInt(this.moduleID);
        buf.m_130085_(this.key);
        StandardFactoryController.getInstance().serialize(buf, this.value);
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony, AbstractBuilding building) {
        IBuildingModule iBuildingModule = building.getModule(this.moduleID);
        if (iBuildingModule instanceof SettingsModule) {
            SettingsModule module = (SettingsModule)iBuildingModule;
            module.updateSetting(new SettingKey(this.value.getClass(), this.key), this.value, ctxIn.getSender());
        }
    }
}

