/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server.colony.building;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.core.colony.buildings.modules.RestaurantMenuModule;
import com.minecolonies.core.network.messages.server.AbstractBuildingServerMessage;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;

public class AlterRestaurantMenuItemMessage
extends AbstractBuildingServerMessage<IBuilding> {
    private ItemStack itemStack;
    private int id;
    private boolean add;

    public AlterRestaurantMenuItemMessage() {
    }

    public static AlterRestaurantMenuItemMessage addMenuItem(IBuildingView building, ItemStack itemStack, int runtimeID) {
        return new AlterRestaurantMenuItemMessage(building, itemStack, runtimeID, true);
    }

    public static AlterRestaurantMenuItemMessage removeMenuItem(IBuildingView building, ItemStack itemStack, int runtimeID) {
        return new AlterRestaurantMenuItemMessage(building, itemStack, runtimeID, false);
    }

    private AlterRestaurantMenuItemMessage(IBuildingView building, ItemStack itemStack, int runtimeID, boolean add) {
        super(building);
        this.itemStack = itemStack;
        this.id = runtimeID;
        this.add = add;
    }

    @Override
    public void fromBytesOverride(@NotNull FriendlyByteBuf buf) {
        this.itemStack = buf.m_130267_();
        this.id = buf.readInt();
        this.add = buf.readBoolean();
    }

    @Override
    public void toBytesOverride(@NotNull FriendlyByteBuf buf) {
        buf.m_130055_(this.itemStack);
        buf.writeInt(this.id);
        buf.writeBoolean(this.add);
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony, IBuilding building) {
        IBuildingModule iBuildingModule = building.getModule(this.id);
        if (iBuildingModule instanceof RestaurantMenuModule) {
            RestaurantMenuModule restaurantMenuModule = (RestaurantMenuModule)iBuildingModule;
            if (this.add) {
                restaurantMenuModule.addMenuItem(this.itemStack);
            } else {
                restaurantMenuModule.removeMenuItem(this.itemStack);
            }
        }
    }
}

