/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.client.colony;

import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.network.IMessage;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColonyViewBuildingViewMessage
implements IMessage {
    private int colonyId;
    private BlockPos buildingId;
    private FriendlyByteBuf buildingData;
    private ResourceKey<Level> dimension;

    public ColonyViewBuildingViewMessage() {
    }

    public ColonyViewBuildingViewMessage(@NotNull IBuilding building) {
        this(building, true);
    }

    public ColonyViewBuildingViewMessage(@NotNull IBuilding building, boolean fullSync) {
        this.colonyId = building.getColony().getID();
        this.buildingId = building.getID();
        this.buildingData = new FriendlyByteBuf(Unpooled.buffer());
        building.serializeToView(this.buildingData, fullSync);
        this.dimension = building.getColony().getDimension();
    }

    @Override
    public void fromBytes(@NotNull FriendlyByteBuf buf) {
        this.colonyId = buf.readInt();
        this.buildingId = buf.m_130135_();
        this.dimension = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(buf.m_130136_(Short.MAX_VALUE)));
        this.buildingData = new FriendlyByteBuf(Unpooled.buffer((int)buf.readableBytes()));
        buf.readBytes((ByteBuf)this.buildingData, buf.readableBytes());
    }

    @Override
    public void toBytes(@NotNull FriendlyByteBuf buf) {
        this.buildingData.resetReaderIndex();
        buf.writeInt(this.colonyId);
        buf.m_130064_(this.buildingId);
        buf.m_130070_(this.dimension.m_135782_().toString());
        buf.writeBytes((ByteBuf)this.buildingData);
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.CLIENT;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        IColonyManager.getInstance().handleColonyBuildingViewMessage(this.colonyId, this.buildingId, this.buildingData, this.dimension);
    }
}

