/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.client;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.network.IMessage;
import com.minecolonies.core.Network;
import com.minecolonies.core.network.messages.client.StopMusicMessage;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public class PlayAudioMessage
implements IMessage {
    private ResourceLocation soundEvent;
    private SoundSource category;

    public PlayAudioMessage() {
    }

    public PlayAudioMessage(SoundEvent event) {
        this.soundEvent = event.m_11660_();
    }

    public PlayAudioMessage(SoundEvent event, SoundSource category) {
        this.soundEvent = event.m_11660_();
        this.category = category;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130130_(this.category.ordinal());
        buf.m_130085_(this.soundEvent);
    }

    @Override
    public void fromBytes(FriendlyByteBuf buf) {
        this.category = SoundSource.values()[buf.m_130242_()];
        this.soundEvent = buf.m_130281_();
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.CLIENT;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new SimpleSoundInstance(this.soundEvent, this.category, 1.0f, 1.0f, RandomSource.m_216327_(), false, 0, SoundInstance.Attenuation.NONE, player.m_20185_(), player.m_20186_(), player.m_20189_(), true));
    }

    public static void sendToAll(IColony col, boolean important, boolean stop, PlayAudioMessage ... messages) {
        List<Player> players = important ? col.getImportantMessageEntityPlayers() : col.getMessagePlayerEntities();
        for (Player player : players) {
            if (stop) {
                Network.getNetwork().sendToPlayer(new StopMusicMessage(), (ServerPlayer)player);
            }
            for (PlayAudioMessage pam : messages) {
                Network.getNetwork().sendToPlayer(pam, (ServerPlayer)player);
            }
        }
    }
}

