/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.managers;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.connections.ColonyConnection;
import com.minecolonies.api.colony.connections.ColonyConnectionNode;
import com.minecolonies.api.colony.connections.ConnectionEvent;
import com.minecolonies.api.colony.connections.ConnectionEventType;
import com.minecolonies.api.colony.connections.DiplomacyStatus;
import com.minecolonies.api.colony.connections.IColonyConnectionManager;
import com.minecolonies.api.colony.connections.PendingConnectionNode;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.core.entity.pathfinding.Pathfinding;
import com.minecolonies.core.entity.pathfinding.pathjobs.PathJobSignConnection;
import com.minecolonies.core.entity.pathfinding.pathresults.PathResult;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.LevelAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColonyConnectionManager
implements IColonyConnectionManager {
    private final Map<BlockPos, ColonyConnectionNode> colonyConnections = new LinkedHashMap<BlockPos, ColonyConnectionNode>();
    private final List<BlockPos> gateHouses = new ArrayList<BlockPos>();
    private final IColony colony;
    private final TreeMap<Integer, ColonyConnection> directlyConnectedColonies = new TreeMap();
    private final TreeMap<Integer, ColonyConnection> indirectlyConnectedColoniesCache = new TreeMap();
    private final Map<Integer, ConnectionEvent> connectionEvents = new TreeMap<Integer, ConnectionEvent>();
    private final Map<BlockPos, PendingConnectionNode> pendingColonyConnections = new LinkedHashMap<BlockPos, PendingConnectionNode>();

    public ColonyConnectionManager(IColony colony) {
        this.colony = colony;
    }

    @Nullable
    private ColonyConnectionNode getClosestNodeWithOpenConnection(BlockPos pos) {
        int distance = Integer.MAX_VALUE;
        ColonyConnectionNode potentialConnection = null;
        for (ColonyConnectionNode node : this.colonyConnections.values()) {
            int localDistance;
            if (node.hasNextNode() || (localDistance = (int)node.getPosition().m_123331_((Vec3i)pos)) > 2500 || localDistance >= distance) continue;
            distance = localDistance;
            potentialConnection = node;
        }
        return potentialConnection;
    }

    @Override
    public boolean addNewConnectionNode(BlockPos connectionPoint) {
        ColonyConnectionNode potentialConnection = this.getClosestNodeWithOpenConnection(connectionPoint);
        if (potentialConnection != null) {
            HashSet<BlockPos> visitedNodes = new HashSet<BlockPos>();
            BlockPos tempNode = potentialConnection.getPreviousNode();
            while (this.colonyConnections.containsKey(tempNode) && !visitedNodes.contains(tempNode)) {
                tempNode = this.colonyConnections.get(tempNode).getPreviousNode();
                visitedNodes.add(tempNode);
            }
            if (tempNode == null && !this.gateHouses.contains(tempNode)) {
                MessageUtils.format("com.minecolonies.core.item.sign.missinglink", new Object[0]).withPriority(MessageUtils.MessagePriority.DANGER).sendTo(this.colony).forManagers();
                return false;
            }
            PendingConnectionNode newNode = new PendingConnectionNode(connectionPoint, this.createSignPath(connectionPoint, potentialConnection.getPosition()), PendingConnectionNode.PendingConnectionType.DEFAULT);
            newNode.alterPreviousNode(potentialConnection.getPosition());
            if (potentialConnection.getTargetColonyId() != -1) {
                newNode.setTargetColonyId(potentialConnection.getTargetColonyId());
            }
            this.pendingColonyConnections.put(connectionPoint, newNode);
            return true;
        }
        for (BlockPos gateHousePos : this.gateHouses) {
            if (!(gateHousePos.m_123331_((Vec3i)connectionPoint) <= 2500.0)) continue;
            PendingConnectionNode newNode = new PendingConnectionNode(connectionPoint, this.createSignPath(connectionPoint, gateHousePos), PendingConnectionNode.PendingConnectionType.DEFAULT);
            newNode.alterPreviousNode(gateHousePos);
            this.pendingColonyConnections.put(connectionPoint, newNode);
            return true;
        }
        MessageUtils.format("com.minecolonies.core.item.sign.toofar", new Object[0]).withPriority(MessageUtils.MessagePriority.DANGER).sendTo(this.colony).forManagers();
        return false;
    }

    @Override
    public void removeConnectionNode(BlockPos connectionPoint) {
        ColonyConnectionNode colonyConnectionNode = this.colonyConnections.remove(connectionPoint);
        if (colonyConnectionNode != null) {
            ColonyConnectionNode nextNode;
            ColonyConnectionNode previousNode = this.colonyConnections.get(colonyConnectionNode.getPreviousNode());
            if (previousNode != null) {
                previousNode.alterNextNode(BlockPos.f_121853_);
                MessageUtils.format((Component)Component.m_237110_((String)"com.minecolonies.core.item.sign.disrupted", (Object[])new Object[]{previousNode.getPosition()})).sendTo(this.colony).forManagers();
            }
            if ((nextNode = this.colonyConnections.get(colonyConnectionNode.getNextNode())) != null) {
                nextNode.alterPreviousNode(BlockPos.f_121853_);
                MessageUtils.format((Component)Component.m_237110_((String)"com.minecolonies.core.item.sign.disrupted", (Object[])new Object[]{nextNode.getPosition()})).sendTo(this.colony).forManagers();
            }
        }
        this.pendingColonyConnections.remove(connectionPoint);
    }

    @Override
    public boolean attemptEstablishConnection(BlockPos targetColonyConnectionPos, IColony targetColony) {
        ColonyConnectionNode thisColonyConnectionPos = this.getClosestNodeWithOpenConnection(targetColonyConnectionPos);
        if (thisColonyConnectionPos == null) {
            MessageUtils.format("com.minecolonies.core.item.sign.toofar", new Object[0]).sendTo(this.colony).forManagers();
            return false;
        }
        PendingConnectionNode newNode = new PendingConnectionNode(thisColonyConnectionPos.getPosition(), this.createSignPath(thisColonyConnectionPos.getPosition(), targetColonyConnectionPos), PendingConnectionNode.PendingConnectionType.CONNECT_COLONY);
        newNode.alterPreviousNode(targetColonyConnectionPos);
        newNode.setTargetColonyId(targetColony.getID());
        this.pendingColonyConnections.put(thisColonyConnectionPos.getPosition(), newNode);
        return true;
    }

    @Override
    public void tick() {
        for (Map.Entry<BlockPos, PendingConnectionNode> pendingConnection : new ArrayList<Map.Entry<BlockPos, PendingConnectionNode>>(this.pendingColonyConnections.entrySet())) {
            if (pendingConnection.getValue().getCachedPathResult() == null) {
                if (!WorldUtil.isBlockLoaded((LevelAccessor)this.colony.getWorld(), pendingConnection.getKey())) continue;
                pendingConnection.getValue().setCachedPathResult(this.createSignPath(pendingConnection.getValue().getPosition(), pendingConnection.getValue().getPreviousNode()));
                continue;
            }
            if (!pendingConnection.getValue().getCachedPathResult().isDone()) continue;
            if (pendingConnection.getValue().getCachedPathResult().isPathReachingDestination()) {
                Object connectedColony;
                ColonyConnectionNode nextNode;
                if (this.pendingColonyConnections.remove(pendingConnection.getKey()) == null) {
                    return;
                }
                ColonyConnectionNode connection = this.colonyConnections.get(pendingConnection.getValue().getPreviousNode());
                if (pendingConnection.getValue().getPendingConnectionType() == PendingConnectionNode.PendingConnectionType.DEFAULT) {
                    if (connection == null && !this.gateHouses.contains(pendingConnection.getValue().getPreviousNode())) {
                        this.colony.getWorld().m_46961_(pendingConnection.getKey(), true);
                        MessageUtils.format("com.minecolonies.core.colonyconnection.path.failure", pendingConnection.getKey().m_123344_(), pendingConnection.getValue().getPreviousNode().m_123344_()).withPriority(MessageUtils.MessagePriority.DANGER).sendTo(this.colony).forManagers();
                        continue;
                    }
                    this.colonyConnections.put(pendingConnection.getKey(), pendingConnection.getValue());
                }
                MessageUtils.format("com.minecolonies.core.item.sign.connected", pendingConnection.getValue().getPosition(), pendingConnection.getValue().getPreviousNode().m_123344_()).withPriority(MessageUtils.MessagePriority.IMPORTANT).sendTo(this.colony).forManagers();
                if (connection != null) {
                    connection.alterNextNode(pendingConnection.getValue().getPosition());
                }
                if (this.gateHouses.contains(pendingConnection.getKey()) && (nextNode = this.colonyConnections.get(pendingConnection.getValue().getNextNode())) != null) {
                    nextNode.alterPreviousNode(pendingConnection.getKey());
                    int targetColonyId = pendingConnection.getValue().getTargetColonyId();
                    if (targetColonyId != -1 && (connectedColony = IColonyManager.getInstance().getColonyByDimension(targetColonyId, this.colony.getDimension())) != null) {
                        connectedColony.getConnectionManager().getDirectlyConnectedColonies().put(this.colony.getID(), new ColonyConnection(this.colony.getID(), this.colony.getName(), pendingConnection.getKey(), this.directlyConnectedColonies.get((Object)Integer.valueOf((int)targetColonyId)).diplomacyStatus));
                    }
                }
                if (pendingConnection.getValue().getPendingConnectionType() == PendingConnectionNode.PendingConnectionType.CONNECT_COLONY) {
                    this.connectToColony(pendingConnection.getKey(), pendingConnection.getValue().getTargetColonyId(), pendingConnection.getValue().getPreviousNode());
                    continue;
                }
                if (pendingConnection.getValue().getPendingConnectionType() != PendingConnectionNode.PendingConnectionType.DEFAULT) continue;
                int distance = Integer.MAX_VALUE;
                ColonyConnectionNode potentialConnection = null;
                connectedColony = this.colonyConnections.values().iterator();
                while (connectedColony.hasNext()) {
                    int localDistance;
                    ColonyConnectionNode node = connectedColony.next();
                    if (!node.getPreviousNode().equals((Object)BlockPos.f_121853_) || node.getPosition().equals((Object)pendingConnection.getKey()) || (localDistance = (int)node.getPosition().m_123331_((Vec3i)pendingConnection.getKey())) > 2500 || localDistance >= distance || node.getPosition().equals((Object)pendingConnection.getKey())) continue;
                    distance = localDistance;
                    potentialConnection = node;
                }
                if (potentialConnection == null) continue;
                PendingConnectionNode newNode = new PendingConnectionNode(potentialConnection.getPosition(), this.createSignPath(potentialConnection.getPosition(), pendingConnection.getKey()), PendingConnectionNode.PendingConnectionType.FIX_PATH);
                newNode.alterPreviousNode(pendingConnection.getKey());
                newNode.alterNextNode(potentialConnection.getNextNode());
                if (pendingConnection.getValue().getTargetColonyId() != -1) {
                    newNode.setTargetColonyId(pendingConnection.getValue().getTargetColonyId());
                } else if (potentialConnection.getTargetColonyId() != -1) {
                    newNode.setTargetColonyId(potentialConnection.getTargetColonyId());
                }
                this.pendingColonyConnections.put(newNode.getPosition(), newNode);
                continue;
            }
            if (pendingConnection.getValue().getPendingConnectionType() != PendingConnectionNode.PendingConnectionType.DEFAULT) continue;
            this.colony.getWorld().m_46961_(pendingConnection.getKey(), true);
            this.pendingColonyConnections.remove(pendingConnection.getKey());
            MessageUtils.format("com.minecolonies.core.colonyconnection.path.failure", pendingConnection.getKey().m_123344_(), pendingConnection.getValue().getPreviousNode().m_123344_()).withPriority(MessageUtils.MessagePriority.DANGER).sendTo(this.colony).forManagers();
        }
        this.updateConnectedColonies(this.directlyConnectedColonies);
        this.updateConnectedColonies(this.indirectlyConnectedColoniesCache);
    }

    private void connectToColony(BlockPos thisColonyConnectionPos, int targetColonyId, BlockPos targetColonyConnectionPos) {
        ColonyConnectionNode node;
        IColony targetColony = IColonyManager.getInstance().getColonyByDimension(targetColonyId, this.colony.getDimension());
        if (targetColony == null) {
            MessageUtils.format((Component)Component.m_237115_((String)"com.minecolonies.core.colonyconnection.fail")).sendTo(this.colony).forManagers();
            return;
        }
        BlockPos thisColonyGatePos = thisColonyConnectionPos;
        HashSet<BlockPos> visitedNodes = new HashSet<BlockPos>();
        while (this.colonyConnections.containsKey(thisColonyGatePos) && visitedNodes.add(thisColonyGatePos = this.colonyConnections.get(thisColonyGatePos).getPreviousNode())) {
        }
        if (thisColonyGatePos == null || !this.gateHouses.contains(thisColonyGatePos)) {
            MessageUtils.format((Component)Component.m_237115_((String)"com.minecolonies.core.colonyconnection.fail")).sendTo(this.colony).forManagers();
            return;
        }
        ColonyConnectionManager targetManager = (ColonyConnectionManager)targetColony.getConnectionManager();
        ColonyConnectionNode targetNode = targetManager.colonyConnections.get(targetColonyConnectionPos);
        if (targetNode != null && targetNode.hasNextNode() && !targetManager.gateHouses.contains(targetColonyConnectionPos)) {
            MessageUtils.format((Component)Component.m_237115_((String)"com.minecolonies.core.colonyconnection.fail")).sendTo(this.colony).forManagers();
            return;
        }
        BlockPos targetColonyGatePos = targetNode == null ? targetColonyConnectionPos : targetNode.getPreviousNode();
        visitedNodes = new HashSet();
        while (targetManager.colonyConnections.containsKey(targetColonyGatePos) && visitedNodes.add(targetColonyGatePos = targetManager.colonyConnections.get(targetColonyGatePos).getPreviousNode())) {
        }
        if (targetColonyGatePos == null || !targetManager.gateHouses.contains(targetColonyGatePos)) {
            MessageUtils.format((Component)Component.m_237115_((String)"com.minecolonies.core.colonyconnection.fail")).sendTo(this.colony).forManagers();
            return;
        }
        this.directlyConnectedColonies.put(targetColony.getID(), new ColonyConnection(targetColony.getID(), targetColony.getName(), targetColonyGatePos, DiplomacyStatus.NEUTRAL));
        targetManager.directlyConnectedColonies.put(this.colony.getID(), new ColonyConnection(this.colony.getID(), this.colony.getName(), thisColonyGatePos, DiplomacyStatus.NEUTRAL));
        ColonyConnectionNode intermediateNode = this.colonyConnections.get(thisColonyConnectionPos);
        intermediateNode.alterNextNode(targetColonyConnectionPos);
        intermediateNode.setTargetColonyId(targetColony.getID());
        if (targetNode != null) {
            targetNode.alterNextNode(thisColonyConnectionPos);
            targetNode.setTargetColonyId(this.colony.getID());
            targetColonyGatePos = targetNode.getPreviousNode();
            while (targetManager.colonyConnections.containsKey(targetColonyGatePos)) {
                node = targetManager.colonyConnections.get(targetColonyGatePos);
                node.setTargetColonyId(this.colony.getID());
                targetColonyGatePos = node.getPreviousNode();
            }
        }
        thisColonyGatePos = thisColonyConnectionPos;
        while (this.colonyConnections.containsKey(thisColonyGatePos)) {
            node = this.colonyConnections.get(thisColonyGatePos);
            node.setTargetColonyId(targetColony.getID());
            thisColonyGatePos = node.getPreviousNode();
        }
        MessageUtils.format("com.minecolonies.core.colonyconnection.success", this.colony.getName(), targetColony.getName()).sendTo(this.colony).forManagers();
        MessageUtils.format("com.minecolonies.core.colonyconnection.success", targetColony.getName(), this.colony.getName()).sendTo(targetColony).forManagers();
        this.colony.markDirty();
    }

    private PathResult createSignPath(BlockPos originPos, BlockPos targetPos) {
        PathJobSignConnection job = new PathJobSignConnection(this.colony.getWorld(), originPos, targetPos, 16);
        job.getResult().startJob(Pathfinding.getExecutor());
        return job.getResult();
    }

    private void updateConnectedColonies(TreeMap<Integer, ColonyConnection> connectedColonies) {
        for (ColonyConnection colonyEntry : new ArrayList<ColonyConnection>(connectedColonies.values())) {
            IColony connectedColony = IColonyManager.getInstance().getColonyByDimension(colonyEntry.id, this.colony.getDimension());
            if (connectedColony == null) {
                connectedColonies.remove(colonyEntry.id);
                continue;
            }
            if (!connectedColony.getName().equals(colonyEntry.name)) {
                connectedColonies.put(colonyEntry.id, new ColonyConnection(connectedColony.getID(), connectedColony.getName(), colonyEntry.pos, colonyEntry.diplomacyStatus));
            }
            if (colonyEntry.diplomacyStatus != DiplomacyStatus.ALLIES) continue;
            for (ColonyConnection indirectConnectedColony : connectedColony.getConnectionManager().getDirectlyConnectedColonies().values()) {
                if (this.directlyConnectedColonies.containsKey(indirectConnectedColony.id) || indirectConnectedColony.id == this.colony.getID()) continue;
                this.indirectlyConnectedColoniesCache.put(indirectConnectedColony.id, indirectConnectedColony);
            }
        }
    }

    @Override
    public TreeMap<Integer, ColonyConnection> getDirectlyConnectedColonies() {
        return this.directlyConnectedColonies;
    }

    @Override
    public TreeMap<Integer, ColonyConnection> getIndirectlyConnectedColonies() {
        return this.indirectlyConnectedColoniesCache;
    }

    @Override
    public ColonyConnectionNode getNode(BlockPos blockPos) {
        return this.colonyConnections.get(blockPos);
    }

    @Override
    public void addNewGateHouse(BlockPos gateHouseConnectionNode) {
        if (!this.gateHouses.contains(gateHouseConnectionNode)) {
            this.gateHouses.add(gateHouseConnectionNode);
            for (ColonyConnectionNode node : this.colonyConnections.values()) {
                if (!node.getPreviousNode().equals((Object)BlockPos.f_121853_) || !(node.getPosition().m_123331_((Vec3i)gateHouseConnectionNode) <= 2500.0)) continue;
                PendingConnectionNode newNode = new PendingConnectionNode(gateHouseConnectionNode, this.createSignPath(gateHouseConnectionNode, node.getPosition()), PendingConnectionNode.PendingConnectionType.FIX_PATH);
                newNode.setTargetColonyId(node.getTargetColonyId());
                newNode.alterNextNode(node.getPosition());
                this.pendingColonyConnections.put(newNode.getPosition(), newNode);
            }
        }
    }

    @Override
    public void removeGateHouse(BlockPos gateHousePosition) {
        for (ColonyConnectionNode colonyConnectionNode : this.colonyConnections.values()) {
            if (!colonyConnectionNode.getPreviousNode().equals((Object)gateHousePosition)) continue;
            colonyConnectionNode.alterPreviousNode(BlockPos.f_121853_);
            MessageUtils.format("com.minecolonies.core.item.sign.disrupted", colonyConnectionNode.getPosition()).sendTo(this.colony).forManagers();
        }
        this.gateHouses.remove(gateHousePosition);
        for (ColonyConnection connectedColonyData : this.directlyConnectedColonies.values()) {
            IColony connectedColony = IColonyManager.getInstance().getColonyByDimension(connectedColonyData.id, this.colony.getDimension());
            if (connectedColony == null) continue;
            connectedColony.getConnectionManager().getDirectlyConnectedColonies().put(this.colony.getID(), new ColonyConnection(this.colony.getID(), this.colony.getName(), BlockPos.f_121853_, connectedColonyData.diplomacyStatus));
        }
    }

    @Override
    public void serializeToView(@NotNull FriendlyByteBuf buf) {
        buf.writeInt(this.directlyConnectedColonies.size());
        for (Map.Entry<Integer, ColonyConnection> connectedColony : this.directlyConnectedColonies.entrySet()) {
            connectedColony.getValue().serializeByteBuf(buf);
        }
        buf.writeInt(this.indirectlyConnectedColoniesCache.size());
        for (Map.Entry<Integer, ColonyConnection> connectedColony : this.indirectlyConnectedColoniesCache.entrySet()) {
            connectedColony.getValue().serializeByteBuf(buf);
        }
        buf.writeInt(this.connectionEvents.size());
        for (ConnectionEvent connectionEventType : this.connectionEvents.values()) {
            connectionEventType.serializeByteBuf(buf);
        }
    }

    @Override
    public void deserializeFromView(@NotNull FriendlyByteBuf buf) {
        int directConnectionsSize = buf.readInt();
        for (int i = 0; i < directConnectionsSize; ++i) {
            ColonyConnection connectedColonyData = new ColonyConnection().deserializeByteBuf(buf);
            this.directlyConnectedColonies.put(connectedColonyData.id, connectedColonyData);
        }
        int indirectConnectionsSize = buf.readInt();
        for (int i = 0; i < indirectConnectionsSize; ++i) {
            ColonyConnection connectedColonyData = new ColonyConnection().deserializeByteBuf(buf);
            this.indirectlyConnectedColoniesCache.put(connectedColonyData.id, connectedColonyData);
        }
        this.connectionEvents.clear();
        int connectionEventSize = buf.readInt();
        for (int i = 0; i < connectionEventSize; ++i) {
            ConnectionEvent connectionEventData = ConnectionEvent.deserializeByteBuf(buf);
            this.connectionEvents.put(connectionEventData.id(), connectionEventData);
        }
    }

    public void deserializeNBT(CompoundTag compound) {
        ListTag connectionTagList = compound.m_128437_("connections", 10);
        for (Object tag : connectionTagList) {
            BlockPos pos = BlockPosUtil.read((CompoundTag)tag, "pos");
            ColonyConnectionNode connectionPoint = new ColonyConnectionNode(pos);
            connectionPoint.read((CompoundTag)tag);
            this.colonyConnections.put(pos, connectionPoint);
        }
        ListTag connectedColonyTagList = compound.m_128437_("colonies", 10);
        for (Object tag : connectedColonyTagList) {
            ColonyConnection colonyConnectionData = new ColonyConnection().deserializeNBT((CompoundTag)tag);
            this.directlyConnectedColonies.put(colonyConnectionData.id, colonyConnectionData);
        }
        this.gateHouses.clear();
        ListTag gateHouseTagList = compound.m_128437_("gatehouses", 10);
        for (Object tag : gateHouseTagList) {
            this.gateHouses.add(BlockPosUtil.read((CompoundTag)tag, "pos"));
        }
        this.connectionEvents.clear();
        ListTag connectionEventList = compound.m_128437_("connectionevents", 10);
        for (Tag tag : connectionEventList) {
            ConnectionEvent connectionEventData = ConnectionEvent.deserializeNBT((CompoundTag)tag);
            this.connectionEvents.put(connectionEventData.id(), connectionEventData);
        }
        ListTag pendingConnectionTagList = compound.m_128437_("pending", 10);
        for (Tag tag : pendingConnectionTagList) {
            BlockPos pos = BlockPosUtil.read((CompoundTag)tag, "pos");
            PendingConnectionNode colonyConnectionData = new PendingConnectionNode(pos);
            colonyConnectionData.read((CompoundTag)tag);
            this.pendingColonyConnections.put(pos, colonyConnectionData);
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag compoundTag = new CompoundTag();
        @NotNull ListTag connectionTagList = new ListTag();
        for (ColonyConnectionNode colonyConnectionNode : this.colonyConnections.values()) {
            connectionTagList.add((Object)colonyConnectionNode.write());
        }
        compoundTag.m_128365_("connections", (Tag)connectionTagList);
        @NotNull ListTag connectedColonyTagList = new ListTag();
        for (Map.Entry<Integer, ColonyConnection> entry : this.directlyConnectedColonies.entrySet()) {
            connectedColonyTagList.add((Object)entry.getValue().serializeNBT());
        }
        compoundTag.m_128365_("colonies", (Tag)connectedColonyTagList);
        @NotNull ListTag listTag = new ListTag();
        for (BlockPos blockPos : this.gateHouses) {
            listTag.add((Object)BlockPosUtil.write(new CompoundTag(), "pos", blockPos));
        }
        compoundTag.m_128365_("gatehouses", (Tag)listTag);
        @NotNull ListTag listTag2 = new ListTag();
        for (ConnectionEvent connectionEvent : this.connectionEvents.values()) {
            listTag2.add((Object)connectionEvent.serializeNBT());
        }
        compoundTag.m_128365_("connectionevents", (Tag)listTag2);
        @NotNull ListTag listTag3 = new ListTag();
        for (PendingConnectionNode connectionEvent : this.pendingColonyConnections.values()) {
            listTag3.add((Object)connectionEvent.write());
        }
        compoundTag.m_128365_("pending", (Tag)listTag3);
        return compoundTag;
    }

    @Override
    public void triggerConnectionEvent(ConnectionEvent connectionEventData) {
        TreeMap<Integer, ColonyConnection> originAffectedMap;
        ColonyConnection originConnectedColonyData;
        TreeMap<Integer, ColonyConnection> affectedMap;
        ColonyConnection connectedColonyData;
        int originColonyId = connectionEventData.id();
        IColony originColony = IColonyManager.getInstance().getColonyByDimension(originColonyId, this.colony.getDimension());
        if (originColony == null) {
            return;
        }
        this.connectionEvents.put(connectionEventData.id(), connectionEventData);
        if (this.directlyConnectedColonies.containsKey(originColonyId)) {
            connectedColonyData = this.directlyConnectedColonies.get(originColonyId);
            affectedMap = this.directlyConnectedColonies;
        } else if (this.indirectlyConnectedColoniesCache.containsKey(originColonyId)) {
            connectedColonyData = this.indirectlyConnectedColoniesCache.get(originColonyId);
            affectedMap = this.indirectlyConnectedColoniesCache;
        } else {
            return;
        }
        DiplomacyStatus diplomacyStatus = switch (connectionEventData.connectionEventType()) {
            case ConnectionEventType.ALLY_CONFIRMED -> DiplomacyStatus.ALLIES;
            case ConnectionEventType.FEUD_STARTED -> DiplomacyStatus.HOSTILE;
            case ConnectionEventType.NEUTRAL_SET -> DiplomacyStatus.NEUTRAL;
            default -> connectedColonyData.diplomacyStatus;
        };
        affectedMap.put(originColonyId, new ColonyConnection(originColonyId, originColony.getName(), connectedColonyData.pos, diplomacyStatus));
        IColonyConnectionManager originColonyConnectionManager = originColony.getConnectionManager();
        if (originColonyConnectionManager.getDirectlyConnectedColonies().containsKey(this.colony.getID())) {
            originConnectedColonyData = originColonyConnectionManager.getDirectlyConnectedColonies().get(this.colony.getID());
            originAffectedMap = originColonyConnectionManager.getDirectlyConnectedColonies();
        } else if (originColonyConnectionManager.getIndirectlyConnectedColonies().containsKey(this.colony.getID())) {
            originConnectedColonyData = originColonyConnectionManager.getIndirectlyConnectedColonies().get(this.colony.getID());
            originAffectedMap = originColonyConnectionManager.getIndirectlyConnectedColonies();
        } else {
            return;
        }
        originAffectedMap.put(this.colony.getID(), new ColonyConnection(this.colony.getID(), this.colony.getName(), originConnectedColonyData.pos, diplomacyStatus));
        originColony.markDirty();
        this.colony.markDirty();
    }

    @Override
    public List<ConnectionEvent> getConnectionEvents() {
        return new ArrayList<ConnectionEvent>(this.connectionEvents.values());
    }

    @Override
    public DiplomacyStatus getColonyDiplomacyStatus(int id) {
        if (this.directlyConnectedColonies.containsKey(id)) {
            return this.directlyConnectedColonies.get((Object)Integer.valueOf((int)id)).diplomacyStatus;
        }
        if (this.indirectlyConnectedColoniesCache.containsKey(id)) {
            return this.indirectlyConnectedColoniesCache.get((Object)Integer.valueOf((int)id)).diplomacyStatus;
        }
        return DiplomacyStatus.NEUTRAL;
    }
}

