/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.workerbuildings;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.jobs.ModJobs;
import com.minecolonies.api.research.IGlobalResearchTree;
import com.minecolonies.api.research.ILocalResearch;
import com.minecolonies.api.util.MathUtils;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.StatsUtil;
import com.minecolonies.core.colony.buildings.AbstractBuilding;
import com.minecolonies.core.colony.buildings.modules.WorkerBuildingModule;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.Tags;
import org.jetbrains.annotations.NotNull;

public class BuildingUniversity
extends AbstractBuilding {
    private static final String UNIVERSITY = "university";
    private static final int OFFLINE_PROCESSING_LEVEL_CAP = 3;
    private final List<BlockPos> bookCases = new ArrayList<BlockPos>();

    public BuildingUniversity(IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return UNIVERSITY;
    }

    @Override
    public void deserializeNBT(CompoundTag compound) {
        super.deserializeNBT(compound);
        ListTag furnaceTagList = compound.m_128437_("bookcase", 10);
        for (int i = 0; i < furnaceTagList.size(); ++i) {
            this.bookCases.add(NbtUtils.m_129239_((CompoundTag)furnaceTagList.m_128728_(i).m_128469_("pos")));
        }
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compound = super.serializeNBT();
        @NotNull ListTag bookcaseTagList = new ListTag();
        for (BlockPos entry : this.bookCases) {
            @NotNull CompoundTag bookCompound = new CompoundTag();
            bookCompound.m_128365_("pos", (Tag)NbtUtils.m_129224_((BlockPos)entry));
            bookcaseTagList.add((Object)bookCompound);
        }
        compound.m_128365_("bookcase", (Tag)bookcaseTagList);
        return compound;
    }

    @Override
    public void registerBlockPosition(@NotNull Block block, @NotNull BlockPos pos, @NotNull Level world) {
        super.registerBlockPosition(block, pos, world);
        if (block.m_49966_().m_204336_(Tags.Blocks.BOOKSHELVES)) {
            this.bookCases.add(pos);
        }
    }

    public BlockPos getRandomBookShelf() {
        if (this.bookCases.isEmpty()) {
            return this.getPosition();
        }
        BlockPos returnPos = this.bookCases.get(MathUtils.RANDOM.nextInt(this.bookCases.size()));
        if (this.colony.getWorld().m_8055_(returnPos).m_204336_(Tags.Blocks.BOOKSHELVES)) {
            return returnPos;
        }
        this.bookCases.remove(returnPos);
        return this.getPosition();
    }

    @Override
    public void onColonyTick(@NotNull IColony colony) {
        super.onColonyTick(colony);
        List<ILocalResearch> inProgress = colony.getResearchManager().getResearchTree().getResearchInProgress();
        WorkerBuildingModule module = (WorkerBuildingModule)this.getModuleMatching(WorkerBuildingModule.class, (T m) -> m.getJobEntry() == ModJobs.researcher.get());
        int i = 1;
        for (ILocalResearch research : inProgress) {
            if (i > module.getAssignedCitizen().size()) {
                return;
            }
            if (colony.getResearchManager().getResearchTree().getResearch(research.getBranch(), research.getId()).research(colony.getResearchManager().getResearchEffects(), colony.getResearchManager().getResearchTree())) {
                this.onSuccess(research);
            }
            colony.getResearchManager().markDirty();
            ++i;
        }
    }

    public void onSuccess(ILocalResearch research) {
        for (ICitizenData citizen : this.colony.getCitizenManager().getCitizens()) {
            citizen.applyResearchEffects();
        }
        StatsUtil.trackStat(this, "research_completed", 1);
        MutableComponent message = Component.m_237110_((String)("com.minecolonies.coremod.university.researchconcluded." + ThreadLocalRandom.current().nextInt(3)), (Object[])new Object[]{MutableComponent.m_237204_((ComponentContents)IGlobalResearchTree.getInstance().getResearch(research.getBranch(), research.getId()).getName())});
        MessageUtils.format((Component)message).sendTo(this.colony).forManagers();
        this.colony.getResearchManager().checkAutoStartResearch();
        this.markDirty();
    }

    @Override
    public void processOfflineTime(long time) {
        if (this.getBuildingLevel() >= 3 && time > 0L) {
            MessageUtils.format("entity.researcher.moreknowledge", new Object[0]).sendTo(this.colony).forAllPlayers();
            for (ICitizenData citizenData : this.getAllAssignedCitizen()) {
                if (citizenData.getJob() == null) continue;
                citizenData.getJob().processOfflineTime(time);
            }
        }
    }
}

