/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.entity.mobs;

import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.entity.CustomGoalSelector;
import com.minecolonies.api.entity.ai.combat.CombatAIStates;
import com.minecolonies.api.entity.ai.combat.threat.IThreatTableEntity;
import com.minecolonies.api.entity.ai.combat.threat.ThreatTable;
import com.minecolonies.api.entity.ai.statemachine.states.IState;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.ITickRateStateMachine;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickRateStateMachine;
import com.minecolonies.api.entity.mobs.RaiderMobUtils;
import com.minecolonies.api.entity.mobs.RaiderType;
import com.minecolonies.api.entity.other.AbstractFastMinecoloniesEntity;
import com.minecolonies.api.entity.pathfinding.registry.IPathNavigateRegistry;
import com.minecolonies.api.sounds.RaiderSounds;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.MathUtils;
import com.minecolonies.core.entity.pathfinding.navigation.AbstractAdvancedPathNavigate;
import com.minecolonies.core.entity.pathfinding.navigation.PathingStuckHandler;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractEntityMinecoloniesMonster
extends AbstractFastMinecoloniesEntity
implements IThreatTableEntity,
Enemy {
    protected AbstractAdvancedPathNavigate newNavigator;
    private int invulTime = 40;
    private int textureId;
    private int collisionCounter = 0;
    private static final int COLL_THRESHOLD = 50;
    private ThreatTable threatTable = new ThreatTable<AbstractEntityMinecoloniesMonster>(this);
    private ITickRateStateMachine<IState> ai = new TickRateStateMachine<CombatAIStates>(CombatAIStates.NO_TARGET, e -> Log.getLogger().warn(e), 5);
    private BlockPos spawnPos = null;

    public AbstractEntityMinecoloniesMonster(EntityType<? extends AbstractEntityMinecoloniesMonster> type, Level world) {
        super(type, world);
        this.m_21530_();
        this.f_21345_ = new CustomGoalSelector(this.f_21345_);
        this.f_21346_ = new CustomGoalSelector(this.f_21346_);
        this.f_21364_ = 5;
        IMinecoloniesAPI.getInstance().getMobAIRegistry().applyToMob(this);
        RaiderMobUtils.setEquipment(this);
    }

    public AbstractEntityMinecoloniesMonster(EntityType<? extends AbstractEntityMinecoloniesMonster> type, Level world, int textureCount) {
        this(type, world);
        this.textureId = MathUtils.RANDOM.nextInt(textureCount);
    }

    @Override
    public void m_6138_() {
        if (this.collisionCounter > 50) {
            return;
        }
        super.m_6138_();
    }

    public void m_7334_(@NotNull Entity entityIn) {
        if (this.invulTime > 0) {
            return;
        }
        if ((this.collisionCounter += 3) > 50) {
            if (this.collisionCounter > 150) {
                this.collisionCounter = 0;
            }
            return;
        }
        super.m_7334_(entityIn);
    }

    public void m_8032_() {
        super.m_8032_();
        SoundEvent soundevent = this.m_7515_();
        if (soundevent != null && this.m_9236_().f_46441_.m_188503_(100) <= 1) {
            this.m_5496_(soundevent, this.m_6121_(), this.m_6100_());
        }
    }

    public abstract RaiderType getRaiderType();

    @NotNull
    public AbstractAdvancedPathNavigate getNavigation() {
        if (this.newNavigator == null) {
            this.newNavigator = IPathNavigateRegistry.getInstance().getNavigateFor((Mob)this);
            this.f_21344_ = this.newNavigator;
            this.newNavigator.m_7008_(true);
            this.newNavigator.setSwimSpeedFactor(this.getSwimSpeedFactor());
            this.newNavigator.getPathingOptions().setEnterDoors(true);
            this.newNavigator.getPathingOptions().setCanOpenDoors(true);
            this.newNavigator.getPathingOptions().withDropCost(1.0);
            this.newNavigator.getPathingOptions().withJumpCost(1.0);
            this.newNavigator.getPathingOptions().setPassDanger(true);
            PathingStuckHandler stuckHandler = PathingStuckHandler.createStuckHandler();
            if (((Boolean)MinecoloniesAPIProxy.getInstance().getConfig().getServer().raidersbreakblocks.get()).booleanValue()) {
                stuckHandler.withBlockBreaks();
                stuckHandler.withCompleteStuckBlockBreak(6);
            }
            this.newNavigator.setStuckHandler(stuckHandler);
        }
        return this.newNavigator;
    }

    public abstract double getSwimSpeedFactor();

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return RaiderSounds.raiderSounds.get((Object)this.getRaiderType()).get((Object)RaiderSounds.RaiderSoundTypes.HURT);
    }

    protected SoundEvent m_5592_() {
        return RaiderSounds.raiderSounds.get((Object)this.getRaiderType()).get((Object)RaiderSounds.RaiderSoundTypes.DEATH);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return RaiderSounds.raiderSounds.get((Object)this.getRaiderType()).get((Object)RaiderSounds.RaiderSoundTypes.SAY);
    }

    @Override
    @Nullable
    public Entity changeDimension(@NotNull ServerLevel serverWorld, @NotNull ITeleporter teleporter) {
        return null;
    }

    public void initStatsFor(double baseHealth, double difficulty, double baseDamage) {
        this.m_21051_((Attribute)RaiderMobUtils.MOB_ATTACK_DAMAGE.get()).m_22100_(baseDamage);
        double armor = difficulty * 1.0;
        this.m_21051_(Attributes.f_22284_).m_22100_(armor);
        this.m_21051_(Attributes.f_22276_).m_22100_(baseHealth);
        this.m_21153_(this.m_21233_());
    }

    public void m_8107_() {
        if (!this.m_6084_()) {
            return;
        }
        if (this.spawnPos == null && this.m_20183_() != BlockPos.f_121853_) {
            this.spawnPos = this.m_20183_();
        }
        this.m_21203_();
        if (this.collisionCounter > 0) {
            --this.collisionCounter;
        }
        if (this.m_9236_().f_46443_) {
            super.m_8107_();
            return;
        }
        if (this.f_19797_ % 5 == 0) {
            this.ai.tick();
        }
        super.m_8107_();
    }

    @Override
    public boolean m_6469_(@NotNull DamageSource damageSource, float damage) {
        if (damageSource.m_7639_() instanceof AbstractEntityMinecoloniesMonster) {
            return false;
        }
        Entity entity = damageSource.m_7639_();
        if (entity instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            if (this.threatTable.getThreatFor(attacker) == -1) {
                for (AbstractEntityMinecoloniesMonster monster : this.f_19853_.m_45976_(AbstractEntityMinecoloniesMonster.class, AABB.m_165882_((Vec3)this.m_20182_(), (double)20.0, (double)5.0, (double)20.0))) {
                    monster.threatTable.addThreat(attacker, 0);
                }
            }
            this.threatTable.addThreat(attacker, (int)damage);
        }
        if (damageSource.m_269150_().m_203565_(DamageTypes.f_268724_)) {
            return super.m_6469_(damageSource, damage);
        }
        return super.m_6469_(damageSource, damage);
    }

    public static AttributeSupplier.Builder getDefaultAttributes() {
        return LivingEntity.m_21183_().m_22266_((Attribute)RaiderMobUtils.MOB_ATTACK_DAMAGE.get()).m_22266_(Attributes.f_22276_).m_22266_(Attributes.f_22284_).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22277_, 70.0).m_22268_(Attributes.f_22281_, Attributes.f_22281_.m_22082_());
    }

    public void m_7380_(CompoundTag compound) {
        if (this.spawnPos != null) {
            compound.m_128356_("spawnPos", this.spawnPos.m_121878_());
        }
        super.m_7380_(compound);
    }

    public void m_7378_(CompoundTag compound) {
        if (compound.m_128441_("spawnPos")) {
            this.spawnPos = BlockPos.m_122022_((long)compound.m_128454_("spawnPos"));
        }
        super.m_7378_(compound);
    }

    public boolean m_6063_() {
        return false;
    }

    @Override
    public ThreatTable getThreatTable() {
        return this.threatTable;
    }

    public ITickRateStateMachine<IState> getAI() {
        return this.ai;
    }

    @Override
    public int getTeamId() {
        return -1;
    }

    public int getTextureId() {
        return this.textureId;
    }

    public BlockPos getSpawnPos() {
        return this.spawnPos;
    }

    public double getDifficulty() {
        return 1.0;
    }

    protected boolean m_8028_() {
        return true;
    }
}

