/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.entity;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import org.jetbrains.annotations.NotNull;

public class CustomGoalSelector
extends GoalSelector {
    private static final WrappedGoal DUMMY = new WrappedGoal(Integer.MAX_VALUE, new Goal(){

        public boolean m_8036_() {
            return false;
        }
    }){

        public boolean m_7620_() {
            return false;
        }
    };
    private final WrappedGoal[] flagGoalsArray = new WrappedGoal[FLAG_COUNT];
    public Set<WrappedGoal> availableGoals = Sets.newHashSet();
    private Supplier<ProfilerFiller> profiler;
    private final boolean[] disabledFlagsArray = new boolean[FLAG_COUNT];
    private static final int FLAG_COUNT = Goal.Flag.values().length;
    int counter = 0;

    public CustomGoalSelector(@NotNull GoalSelector old) {
        super(old.f_25346_);
        this.importFrom(old);
        this.f_25345_ = this.availableGoals;
        this.f_25346_ = this.profiler;
    }

    public CustomGoalSelector(@NotNull Supplier<ProfilerFiller> profiler) {
        super(profiler);
        this.profiler = profiler;
        this.f_25345_ = this.availableGoals;
        this.f_25346_ = this.profiler;
        for (Goal.Flag flag : Goal.Flag.values()) {
            this.flagGoalsArray[flag.ordinal()] = DUMMY;
        }
    }

    public void importFrom(GoalSelector selector) {
        if (selector == null) {
            return;
        }
        for (Goal.Flag flag : Goal.Flag.values()) {
            this.flagGoalsArray[flag.ordinal()] = selector.f_25344_.getOrDefault(flag, DUMMY);
        }
        this.availableGoals = selector.f_25345_;
        this.profiler = selector.f_25346_;
        for (Goal.Flag flag : selector.f_25347_) {
            this.disabledFlagsArray[flag.ordinal()] = true;
        }
    }

    public void m_25352_(int priority, Goal task) {
        this.availableGoals.add(new WrappedGoal(priority, task));
    }

    public void m_25363_(Goal task) {
        for (WrappedGoal prioritizedGoal : new ArrayList<WrappedGoal>(this.availableGoals)) {
            if (prioritizedGoal.m_26015_() != task) continue;
            prioritizedGoal.m_8041_();
            this.availableGoals.remove(prioritizedGoal);
        }
    }

    private boolean goalContainsDisabledFlag(WrappedGoal goal) {
        for (int i = 0; i < FLAG_COUNT; ++i) {
            if (!this.disabledFlagsArray[i] || !goal.m_7684_().contains(Goal.Flag.values()[i])) continue;
            return true;
        }
        return false;
    }

    private boolean isPreemptedByAll(WrappedGoal goal1) {
        for (int i = 0; i < FLAG_COUNT; ++i) {
            WrappedGoal compareGoal = this.flagGoalsArray[i];
            if (!compareGoal.m_7620_() || compareGoal.m_26002_(goal1) || !goal1.m_7684_().contains(Goal.Flag.values()[i])) continue;
            return false;
        }
        return true;
    }

    public void m_25373_() {
        this.profiler.get().m_6180_("goalUpdate");
        ++this.counter;
        for (WrappedGoal currentGoal : new ArrayList<WrappedGoal>(this.availableGoals)) {
            boolean hasFlags;
            boolean bl = hasFlags = !currentGoal.m_7684_().isEmpty();
            if (currentGoal.m_7620_() && (hasFlags && this.goalContainsDisabledFlag(currentGoal) || !currentGoal.m_8045_())) {
                currentGoal.m_8041_();
            }
            if (this.counter == 1 && !currentGoal.m_7620_() && (!hasFlags && currentGoal.m_8036_() || !this.goalContainsDisabledFlag(currentGoal) && this.isPreemptedByAll(currentGoal) && currentGoal.m_8036_())) {
                for (Goal.Flag flag : currentGoal.m_7684_()) {
                    WrappedGoal prioritizedgoal = this.flagGoalsArray[flag.ordinal()];
                    prioritizedgoal.m_8041_();
                    this.flagGoalsArray[flag.ordinal()] = currentGoal;
                }
                currentGoal.m_8056_();
            }
            if (!currentGoal.m_7620_()) continue;
            currentGoal.m_8037_();
        }
        if (this.counter > 3) {
            this.counter = 0;
        }
        this.profiler.get().m_7238_();
    }

    public Stream<WrappedGoal> m_25386_() {
        return this.availableGoals.stream().filter(WrappedGoal::m_7620_);
    }

    public void m_25355_(Goal.Flag flag) {
        this.disabledFlagsArray[flag.ordinal()] = true;
    }

    public void m_25374_(Goal.Flag flag) {
        this.disabledFlagsArray[flag.ordinal()] = false;
    }

    public void m_25360_(Goal.Flag flag, boolean enabled) {
        if (enabled) {
            this.m_25374_(flag);
        } else {
            this.m_25355_(flag);
        }
    }
}

