/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.requestsystem.token;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.token.ITokenFactory;
import com.minecolonies.api.colony.requestsystem.token.StandardToken;
import com.minecolonies.api.util.constant.TypeConstants;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractTokenFactory<I>
implements ITokenFactory<I, StandardToken> {
    public static final String NBT_MSB = "Id_MSB";
    public static final String NBT_LSB = "Id_LSB";

    @Override
    @NotNull
    public TypeToken<StandardToken> getFactoryOutputType() {
        return TypeConstants.STANDARDTOKEN;
    }

    @Override
    @NotNull
    public CompoundTag serialize(@NotNull IFactoryController controller, @NotNull StandardToken request) {
        CompoundTag compound = new CompoundTag();
        compound.m_128356_(NBT_LSB, request.getIdentifier().getLeastSignificantBits());
        compound.m_128356_(NBT_MSB, request.getIdentifier().getMostSignificantBits());
        return compound;
    }

    @Override
    @NotNull
    public StandardToken deserialize(@NotNull IFactoryController controller, @NotNull CompoundTag nbt) {
        Long msb = nbt.m_128454_(NBT_MSB);
        Long lsb = nbt.m_128454_(NBT_LSB);
        UUID id = new UUID(msb, lsb);
        return new StandardToken(id);
    }

    @Override
    public void serialize(IFactoryController controller, StandardToken input, FriendlyByteBuf packetBuffer) {
        packetBuffer.writeLong(input.getIdentifier().getLeastSignificantBits());
        packetBuffer.writeLong(input.getIdentifier().getMostSignificantBits());
    }

    @Override
    public StandardToken deserialize(IFactoryController controller, FriendlyByteBuf buffer) throws Throwable {
        long lsb = buffer.readLong();
        long msb = buffer.readLong();
        UUID id = new UUID(msb, lsb);
        return new StandardToken(id);
    }
}

