/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.integration.theoneprobe;

import de.maxhenkel.easyvillagers.blocks.tileentity.BreederTileentity;
import de.maxhenkel.easyvillagers.blocks.tileentity.ConverterTileentity;
import de.maxhenkel.easyvillagers.blocks.tileentity.VillagerTileentity;
import de.maxhenkel.easyvillagers.entity.EasyVillagerEntity;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class TileInfoProvider
implements IProbeInfoProvider {
    public static final ResourceLocation ID = new ResourceLocation("easy_villagers", "probeinfoprovider");

    public ResourceLocation getID() {
        return ID;
    }

    public void addProbeInfo(ProbeMode probeMode, IProbeInfo iProbeInfo, Player playerEntity, Level world, BlockState blockState, IProbeHitData iProbeHitData) {
        ConverterTileentity converter;
        long timer;
        BlockEntity te = world.m_7702_(iProbeHitData.getPos());
        if (te instanceof VillagerTileentity) {
            VillagerTileentity v = (VillagerTileentity)te;
            this.addVillager(v.getVillagerEntity(), iProbeInfo);
        } else if (te instanceof BreederTileentity) {
            BreederTileentity breeder = (BreederTileentity)te;
            if (probeMode.equals((Object)ProbeMode.EXTENDED)) {
                this.addVillager(breeder.getVillagerEntity1(), iProbeInfo);
                this.addVillager(breeder.getVillagerEntity2(), iProbeInfo);
            }
        }
        if (te instanceof ConverterTileentity && (timer = (converter = (ConverterTileentity)te).getTimer()) >= 0L && converter.hasVillager()) {
            iProbeInfo.progress(timer, (long)ConverterTileentity.getConvertTime(), iProbeInfo.defaultProgressStyle().showText(false));
        }
    }

    private void addVillager(EasyVillagerEntity villager, IProbeInfo iProbeInfo) {
        if (villager != null) {
            IProbeInfo info = iProbeInfo.horizontal(iProbeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER));
            info.entity((Entity)villager).text(villager.getAdvancedName());
        }
    }
}

