/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.api.fluids;

import com.tiviacz.travelersbackpack.fluids.EffectFluidRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

public abstract class EffectFluid {
    public final String uniqueId;
    public final Fluid fluid;
    public int effectID;
    public final int amountRequired;

    public EffectFluid(String uniqueId, FluidStack fluidStack, int amountRequired) {
        this(uniqueId, fluidStack.getFluid(), amountRequired);
    }

    public EffectFluid(String uniqueId, Fluid fluid, int amountRequired) {
        this.uniqueId = uniqueId;
        this.fluid = fluid;
        this.effectID = 0;
        this.amountRequired = amountRequired;
        if (fluid != null) {
            EffectFluidRegistry.registerFluidEffect(this);
        }
    }

    public EffectFluid(String uniqueId, String modid, String fluidName, int amountRequired) {
        Fluid fluid = (Fluid)BuiltInRegistries.f_257020_.m_7745_(new ResourceLocation(modid, fluidName));
        this.uniqueId = uniqueId;
        this.fluid = fluid;
        this.effectID = 0;
        this.amountRequired = amountRequired;
        if (fluid != null) {
            EffectFluidRegistry.registerFluidEffect(this);
        }
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public void setEffectID(int id) {
        this.effectID = id;
    }

    public int getEffectID() {
        return this.effectID;
    }

    public abstract void affectDrinker(FluidStack var1, Level var2, Entity var3);

    public abstract boolean canExecuteEffect(FluidStack var1, Level var2, Entity var3);
}

