/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.utils;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.client.scene.ParticleManager;
import com.lowdragmc.lowdraglib.core.mixins.accessor.EntityAccessor;
import com.lowdragmc.lowdraglib.utils.BlockInfo;
import com.lowdragmc.lowdraglib.utils.DummyWorld;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.material.FluidState;
import org.joml.Vector3f;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class TrackedDummyWorld
extends DummyWorld {
    private Predicate<BlockPos> renderFilter;
    public final WeakReference<Level> proxyWorld;
    public final Map<BlockPos, BlockInfo> renderedBlocks = new HashMap<BlockPos, BlockInfo>();
    public final Map<BlockPos, BlockEntity> blockEntities = new HashMap<BlockPos, BlockEntity>();
    public final Map<Integer, Entity> entities = new Int2ObjectArrayMap();
    public final Vector3f minPos = new Vector3f(2.1474836E9f, 2.1474836E9f, 2.1474836E9f);
    public final Vector3f maxPos = new Vector3f(-2.1474836E9f, -2.1474836E9f, -2.1474836E9f);

    public TrackedDummyWorld() {
        super((Level)Minecraft.m_91087_().f_91073_);
        this.proxyWorld = new WeakReference<Object>(null);
    }

    public TrackedDummyWorld(Level world) {
        super(world);
        this.proxyWorld = new WeakReference<Level>(world);
    }

    public void clear() {
        this.renderedBlocks.clear();
        this.blockEntities.clear();
        this.entities.clear();
    }

    public void addBlocks(Map<BlockPos, BlockInfo> renderedBlocks) {
        renderedBlocks.forEach(this::addBlock);
    }

    public void addBlock(BlockPos pos, BlockInfo blockInfo) {
        if (blockInfo.getBlockState().m_60734_() == Blocks.f_50016_) {
            return;
        }
        this.renderedBlocks.put(pos, blockInfo);
        this.blockEntities.remove(pos);
        this.minPos.x = Math.min(this.minPos.x, (float)pos.m_123341_());
        this.minPos.y = Math.min(this.minPos.y, (float)pos.m_123342_());
        this.minPos.z = Math.min(this.minPos.z, (float)pos.m_123343_());
        this.maxPos.x = Math.max(this.maxPos.x, (float)pos.m_123341_());
        this.maxPos.y = Math.max(this.maxPos.y, (float)pos.m_123342_());
        this.maxPos.z = Math.max(this.maxPos.z, (float)pos.m_123343_());
    }

    public BlockInfo removeBlock(BlockPos pos) {
        this.blockEntities.remove(pos);
        return this.renderedBlocks.remove(pos);
    }

    public void setInnerBlockEntity(@Nonnull BlockEntity pBlockEntity) {
        this.blockEntities.put(pBlockEntity.m_58899_(), pBlockEntity);
    }

    @Override
    public void m_151523_(@Nonnull BlockEntity pBlockEntity) {
        this.blockEntities.put(pBlockEntity.m_58899_(), pBlockEntity);
    }

    @Override
    public boolean m_6933_(@Nonnull BlockPos pos, @Nonnull BlockState state, int a, int b) {
        this.renderedBlocks.put(pos, BlockInfo.fromBlockState(state));
        this.blockEntities.remove(pos);
        return true;
    }

    @Override
    public BlockEntity m_7702_(@Nonnull BlockPos pos) {
        if (this.renderFilter != null && !this.renderFilter.test(pos)) {
            return null;
        }
        Level proxy = (Level)this.proxyWorld.get();
        return proxy != null ? proxy.m_7702_(pos) : this.blockEntities.computeIfAbsent(pos, p -> this.renderedBlocks.getOrDefault(p, BlockInfo.EMPTY).getBlockEntity(this, (BlockPos)p));
    }

    @Override
    public BlockState m_8055_(@Nonnull BlockPos pos) {
        if (this.renderFilter != null && !this.renderFilter.test(pos)) {
            return Blocks.f_50016_.m_49966_();
        }
        Level proxy = (Level)this.proxyWorld.get();
        return proxy != null ? proxy.m_8055_(pos) : this.renderedBlocks.getOrDefault(pos, BlockInfo.EMPTY).getBlockState();
    }

    public boolean m_7967_(Entity entity) {
        ((EntityAccessor)entity).invokeSetLevel(this);
        if (entity instanceof ItemFrame) {
            ItemFrame itemFrame = (ItemFrame)entity;
            itemFrame.m_31805_(TrackedDummyWorld.withUnsafeNBTDiscarded(itemFrame.m_31822_()));
        }
        if (entity instanceof ArmorStand) {
            ArmorStand armorStand = (ArmorStand)entity;
            for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
                armorStand.m_8061_(equipmentSlot, TrackedDummyWorld.withUnsafeNBTDiscarded(armorStand.m_6844_(equipmentSlot)));
            }
        }
        this.entities.put(entity.m_19879_(), entity);
        return true;
    }

    public static ItemStack withUnsafeNBTDiscarded(ItemStack stack) {
        if (stack.m_41783_() == null) {
            return stack;
        }
        ItemStack copy = stack.m_41777_();
        stack.m_41783_().m_128431_().stream().filter(TrackedDummyWorld::isUnsafeItemNBTKey).forEach(arg_0 -> ((ItemStack)copy).m_41749_(arg_0));
        if (copy.m_41783_().m_128456_()) {
            copy.m_41751_(null);
        }
        return copy;
    }

    public static boolean isUnsafeItemNBTKey(String name) {
        if (name.equals("StoredEnchantments")) {
            return false;
        }
        if (name.equals("Enchantments")) {
            return false;
        }
        if (name.contains("Potion")) {
            return false;
        }
        if (name.contains("Damage")) {
            return false;
        }
        return !name.equals("display");
    }

    @Override
    protected LevelEntityGetter<Entity> m_142646_() {
        return super.m_142646_();
    }

    @Override
    public Entity m_6815_(int id) {
        for (Entity entity : this.entities.values()) {
            if (entity.m_19879_() != id || !entity.m_6084_()) continue;
            return entity;
        }
        return super.m_6815_(id);
    }

    public Vector3f getSize() {
        return new Vector3f(this.maxPos.x - this.minPos.x + 1.0f, this.maxPos.y - this.minPos.y + 1.0f, this.maxPos.z - this.minPos.z + 1.0f);
    }

    @Override
    public ChunkSource m_7726_() {
        Level proxy = (Level)this.proxyWorld.get();
        return proxy == null ? super.m_7726_() : proxy.m_7726_();
    }

    @Override
    public FluidState m_6425_(BlockPos pPos) {
        Level proxy = (Level)this.proxyWorld.get();
        return proxy == null ? super.m_6425_(pPos) : proxy.m_6425_(pPos);
    }

    public int m_6171_(@Nonnull BlockPos blockPos, @Nonnull ColorResolver colorResolver) {
        Level proxy = (Level)this.proxyWorld.get();
        return proxy == null ? super.m_6171_(blockPos, colorResolver) : proxy.m_6171_(blockPos, colorResolver);
    }

    @Override
    @Nonnull
    public Holder<Biome> m_204166_(@Nonnull BlockPos pos) {
        Level proxy = (Level)this.proxyWorld.get();
        return proxy == null ? super.m_204166_(pos) : proxy.m_204166_(pos);
    }

    @Override
    public void setParticleManager(ParticleManager particleManager) {
        super.setParticleManager(particleManager);
        Object t = this.proxyWorld.get();
        if (t instanceof DummyWorld) {
            DummyWorld dummyWorld = (DummyWorld)((Object)t);
            dummyWorld.setParticleManager(particleManager);
        }
    }

    @Override
    @Nullable
    public ParticleManager getParticleManager() {
        Object t;
        ParticleManager particleManager = super.getParticleManager();
        if (particleManager == null && (t = this.proxyWorld.get()) instanceof DummyWorld) {
            DummyWorld dummyWorld = (DummyWorld)((Object)t);
            return dummyWorld.getParticleManager();
        }
        return particleManager;
    }

    public void tickWorld() {
        Iterator<Entity> iter = this.entities.values().iterator();
        while (iter.hasNext()) {
            Entity entity = iter.next();
            ++entity.f_19797_;
            entity.m_146867_();
            entity.m_8119_();
            if (entity.m_20186_() <= -0.5) {
                entity.m_146870_();
            }
            if (entity.m_6084_()) continue;
            iter.remove();
        }
        for (Map.Entry<BlockPos, BlockInfo> entry : this.renderedBlocks.entrySet()) {
            BlockState blockState = entry.getValue().getBlockState();
            BlockEntity blockEntity = this.m_7702_(entry.getKey());
            if (blockEntity == null || !blockEntity.m_58903_().m_155262_(blockState)) continue;
            try {
                BlockEntityTicker ticker = blockState.m_155944_((Level)this, blockEntity.m_58903_());
                if (ticker == null) continue;
                ticker.m_155252_((Level)this, entry.getKey(), blockState, blockEntity);
            }
            catch (Exception e) {
                LDLib.LOGGER.error("error while update DummyWorld tick, pos {} type {}", new Object[]{entry.getKey(), blockEntity.m_58903_(), e});
            }
        }
    }

    public List<Entity> getAllEntities() {
        ArrayList<Entity> entities = new ArrayList<Entity>(this.entities.values());
        Object t = this.proxyWorld.get();
        if (t instanceof TrackedDummyWorld) {
            TrackedDummyWorld trackedDummyWorld = (TrackedDummyWorld)((Object)t);
            entities.addAll(trackedDummyWorld.getAllEntities());
        }
        return entities;
    }

    public void setRenderFilter(Predicate<BlockPos> renderFilter) {
        this.renderFilter = renderFilter;
    }

    public Map<BlockPos, BlockInfo> getRenderedBlocks() {
        return this.renderedBlocks;
    }

    public Vector3f getMinPos() {
        return this.minPos;
    }

    public Vector3f getMaxPos() {
        return this.maxPos;
    }
}

