/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.utils;

public class Interpolations {
    public static double CatmullRom(double t, double p0, double p1, double p2, double p3) {
        double v0 = (p2 - p0) * 0.5;
        double v1 = (p3 - p1) * 0.5;
        double t2 = t * t;
        double t3 = t * t2;
        return (2.0 * p1 - 2.0 * p2 + v0 + v1) * t3 + (-3.0 * p1 + 3.0 * p2 - 2.0 * v0 - v1) * t2 + v0 * t + p1;
    }

    public static double QuadraticBezierP0(double t, double p) {
        double k = 1.0 - t;
        return k * k * p;
    }

    public static double QuadraticBezierP1(double t, double p) {
        return 2.0 * (1.0 - t) * t * p;
    }

    public static double QuadraticBezierP2(double t, double p) {
        return t * t * p;
    }

    public static double QuadraticBezier(double t, double p0, double p1, double p2) {
        return Interpolations.QuadraticBezierP0(t, p0) + Interpolations.QuadraticBezierP1(t, p1) + Interpolations.QuadraticBezierP2(t, p2);
    }

    public static double CubicBezierP0(double t, double p) {
        double k = 1.0 - t;
        return k * k * k * p;
    }

    public static double CubicBezierP1(double t, double p) {
        double k = 1.0 - t;
        return 3.0 * k * k * t * p;
    }

    public static double CubicBezierP2(double t, double p) {
        return 3.0 * (1.0 - t) * t * t * p;
    }

    public static double CubicBezierP3(double t, double p) {
        return t * t * t * p;
    }

    public static double CubicBezier(double t, double p0, double p1, double p2, double p3) {
        return Interpolations.CubicBezierP0(t, p0) + Interpolations.CubicBezierP1(t, p1) + Interpolations.CubicBezierP2(t, p2) + Interpolations.CubicBezierP3(t, p3);
    }
}

