/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.syncdata.managed;

import com.lowdragmc.lowdraglib.syncdata.managed.IManagedVar;
import java.lang.reflect.Field;

public class ManagedField<T>
implements IManagedVar<T> {
    protected Field field;
    protected Class<T> type;
    protected Object instance;

    public static <T> IManagedVar<T> of(Field field, Object instance) {
        Class<?> type = field.getType();
        if (type == Integer.TYPE) {
            return new Int(field, instance);
        }
        if (type == java.lang.Long.TYPE) {
            return new Long(field, instance);
        }
        if (type == java.lang.Float.TYPE) {
            return new Float(field, instance);
        }
        if (type == java.lang.Double.TYPE) {
            return new Double(field, instance);
        }
        if (type == java.lang.Boolean.TYPE) {
            return new Boolean(field, instance);
        }
        if (type == java.lang.Byte.TYPE) {
            return new Byte(field, instance);
        }
        if (type == Character.TYPE) {
            return new Char(field, instance);
        }
        if (type == java.lang.Short.TYPE) {
            return new Short(field, instance);
        }
        return new ManagedField<T>(field, instance);
    }

    protected ManagedField(Field field, Object instance) {
        field.setAccessible(true);
        this.type = field.getType();
        this.field = field;
        this.instance = instance;
    }

    @Override
    public boolean isPrimitive() {
        return this.type.isPrimitive();
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    @Override
    public T value() {
        try {
            return (T)this.field.get(this.instance);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void set(T value) {
        try {
            this.field.set(this.instance, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    static class Int
    extends ManagedField<Integer>
    implements IManagedVar.Int {
        private Int(Field field, Object instance) {
            super(field, instance);
        }

        @Override
        public int intValue() {
            try {
                return this.field.getInt(this.instance);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void setInt(int value) {
            try {
                this.field.setInt(this.instance, value);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static class Long
    extends ManagedField<java.lang.Long>
    implements IManagedVar.Long {
        private Long(Field field, Object instance) {
            super(field, instance);
        }

        @Override
        public long longValue() {
            try {
                return this.field.getLong(this.instance);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void setLong(long value) {
            try {
                this.field.setLong(this.instance, value);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static class Float
    extends ManagedField<java.lang.Float>
    implements IManagedVar.Float {
        private Float(Field field, Object instance) {
            super(field, instance);
        }

        @Override
        public float floatValue() {
            try {
                return this.field.getFloat(this.instance);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void setFloat(float value) {
            try {
                this.field.setFloat(this.instance, value);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static class Double
    extends ManagedField<java.lang.Double>
    implements IManagedVar.Double {
        private Double(Field field, Object instance) {
            super(field, instance);
        }

        @Override
        public double doubleValue() {
            try {
                return this.field.getDouble(this.instance);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void setDouble(double value) {
            try {
                this.field.setDouble(this.instance, value);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static class Boolean
    extends ManagedField<java.lang.Boolean>
    implements IManagedVar.Boolean {
        private Boolean(Field field, Object instance) {
            super(field, instance);
        }

        @Override
        public boolean booleanValue() {
            try {
                return this.field.getBoolean(this.instance);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void setBoolean(boolean value) {
            try {
                this.field.setBoolean(this.instance, value);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static class Byte
    extends ManagedField<java.lang.Byte>
    implements IManagedVar.Byte {
        private Byte(Field field, Object instance) {
            super(field, instance);
        }

        @Override
        public byte byteValue() {
            try {
                return this.field.getByte(this.instance);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void setByte(byte value) {
            try {
                this.field.setByte(this.instance, value);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static class Char
    extends ManagedField<Character>
    implements IManagedVar.Char {
        private Char(Field field, Object instance) {
            super(field, instance);
        }

        @Override
        public char charValue() {
            try {
                return this.field.getChar(this.instance);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void setChar(char value) {
            try {
                this.field.setChar(this.instance, value);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static class Short
    extends ManagedField<java.lang.Short>
    implements IManagedVar.Short {
        private Short(Field field, Object instance) {
            super(field, instance);
        }

        @Override
        public short shortValue() {
            try {
                return this.field.getShort(this.instance);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void setShort(short value) {
            try {
                this.field.setShort(this.instance, value);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

