/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.syncdata.field;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.syncdata.IManaged;
import com.lowdragmc.lowdraglib.syncdata.ManagedFieldUtils;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedKey;
import com.lowdragmc.lowdraglib.syncdata.field.RPCMethodMeta;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;

public class ManagedFieldHolder {
    private final Map<String, ManagedKey> fieldNameMap = new HashMap<String, ManagedKey>();
    private ManagedKey[] fields;
    private Map<String, RPCMethodMeta> rpcMethodMap = new HashMap<String, RPCMethodMeta>();
    private final Class<? extends IManaged> clazz;

    public ManagedFieldHolder(Class<? extends IManaged> clazz) {
        this.clazz = clazz;
        this.initAll();
    }

    public void merge(ManagedFieldHolder other) {
        this.fields = (ManagedKey[])ArrayUtils.addAll((Object[])this.fields, (Object[])other.fields);
        this.resetSyncFieldIndexMap();
        this.rpcMethodMap.putAll(other.rpcMethodMap);
    }

    public ManagedFieldHolder(Class<? extends IManaged> clazz, ManagedFieldHolder parent) {
        this(clazz);
        this.merge(parent);
    }

    private void initAll() {
        this.fields = ManagedFieldUtils.getManagedFields(this.clazz);
        this.resetSyncFieldIndexMap();
        this.rpcMethodMap = ManagedFieldUtils.getRPCMethods(this.clazz);
    }

    private void resetSyncFieldIndexMap() {
        this.fieldNameMap.clear();
        for (ManagedKey key : this.fields) {
            if (this.fieldNameMap.containsKey(key.getName())) {
                LDLib.LOGGER.warn("Duplicate sync field name: " + key.getName());
                continue;
            }
            this.fieldNameMap.put(key.getName(), key);
        }
    }

    public ManagedKey[] getFields() {
        return this.fields;
    }

    public Map<String, RPCMethodMeta> getRpcMethodMap() {
        return this.rpcMethodMap;
    }

    public ManagedKey getSyncedFieldIndex(String name) {
        if (!this.fieldNameMap.containsKey(name)) {
            throw new IllegalArgumentException("No sync field with name " + name);
        }
        return this.fieldNameMap.get(name);
    }
}

