/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.syncdata.accessor;

import com.lowdragmc.lowdraglib.syncdata.AccessorOp;
import com.lowdragmc.lowdraglib.syncdata.IAccessor;
import com.lowdragmc.lowdraglib.syncdata.managed.IManagedVar;
import com.lowdragmc.lowdraglib.syncdata.managed.IRef;
import com.lowdragmc.lowdraglib.syncdata.managed.ManagedRef;
import com.lowdragmc.lowdraglib.syncdata.payload.ITypedPayload;
import com.lowdragmc.lowdraglib.syncdata.payload.PrimitiveTypedPayload;

public abstract class ManagedAccessor
implements IAccessor {
    private byte defaultType = (byte)-1;

    @Override
    public byte getDefaultType() {
        return this.defaultType;
    }

    @Override
    public void setDefaultType(byte defaultType) {
        this.defaultType = defaultType;
    }

    @Override
    public boolean isManaged() {
        return true;
    }

    @Override
    public abstract ITypedPayload<?> readManagedField(AccessorOp var1, IManagedVar<?> var2);

    @Override
    public abstract void writeManagedField(AccessorOp var1, IManagedVar<?> var2, ITypedPayload<?> var3);

    @Override
    public ITypedPayload<?> readField(AccessorOp op, IRef field) {
        if (!(field instanceof ManagedRef)) {
            throw new IllegalArgumentException("Field %s is not a managed field".formatted(field));
        }
        ManagedRef syncedField = (ManagedRef)field;
        Object managedField = syncedField.getField();
        if (!managedField.isPrimitive() && managedField.value() == null) {
            return PrimitiveTypedPayload.ofNull();
        }
        return this.readManagedField(op, (IManagedVar<?>)managedField);
    }

    @Override
    public void writeField(AccessorOp op, IRef field, ITypedPayload<?> payload) {
        if (!(field instanceof ManagedRef)) {
            throw new IllegalArgumentException("Field %s is not a managed field".formatted(field));
        }
        ManagedRef syncedField = (ManagedRef)field;
        Object managedField = syncedField.getField();
        this.writeManagedField(op, (IManagedVar<?>)managedField, payload);
    }
}

