/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.syncdata.accessor;

import com.lowdragmc.lowdraglib.syncdata.AccessorOp;
import com.lowdragmc.lowdraglib.syncdata.accessor.ManagedAccessor;
import com.lowdragmc.lowdraglib.syncdata.managed.IManagedVar;
import com.lowdragmc.lowdraglib.syncdata.payload.ITypedPayload;
import com.lowdragmc.lowdraglib.syncdata.payload.PrimitiveTypedPayload;
import java.util.Objects;

public abstract class CustomObjectAccessor<T>
extends ManagedAccessor {
    private final Class<T> type;
    private final boolean includesChildren;
    private final Class<?>[] operandTypes;

    protected CustomObjectAccessor(Class<T> type, boolean includesChildren) {
        this.type = type;
        this.includesChildren = includesChildren;
        this.operandTypes = new Class[]{type};
    }

    @Override
    public boolean hasPredicate() {
        return this.includesChildren;
    }

    @Override
    public boolean test(Class<?> type) {
        return this.type.isAssignableFrom(type);
    }

    @Override
    public Class<?>[] operandTypes() {
        return this.operandTypes;
    }

    public abstract ITypedPayload<?> serialize(AccessorOp var1, T var2);

    public abstract T deserialize(AccessorOp var1, ITypedPayload<?> var2);

    @Override
    public ITypedPayload<?> readManagedField(AccessorOp op, IManagedVar<?> field) {
        Object value = field.value();
        if (value != null) {
            if (!this.type.isAssignableFrom(value.getClass())) {
                throw new IllegalArgumentException("Value %s is not assignable to type %s".formatted(value, this.type));
            }
            return this.serialize(op, value);
        }
        return PrimitiveTypedPayload.ofNull();
    }

    @Override
    public void writeManagedField(AccessorOp op, IManagedVar<?> field, ITypedPayload<?> payload) {
        PrimitiveTypedPayload primitive;
        if (payload instanceof PrimitiveTypedPayload && (primitive = (PrimitiveTypedPayload)payload).isNull()) {
            field.set(null);
            return;
        }
        T result = this.deserialize(op, payload);
        Objects.requireNonNull(result, "Payload %s is not a valid payload for type %s".formatted(payload, this.type));
        field.set(result);
    }
}

