/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.syncdata;

import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import java.lang.reflect.Array;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class SyncUtils {
    public static boolean isChanged(@NotNull Object oldValue, @NotNull Object newValue) {
        if (oldValue instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)oldValue;
            if (!(newValue instanceof ItemStack)) {
                return true;
            }
            return !ItemStack.m_41728_((ItemStack)itemStack, (ItemStack)((ItemStack)newValue));
        }
        if (oldValue instanceof FluidStack) {
            FluidStack fluidStack = (FluidStack)oldValue;
            if (!(newValue instanceof FluidStack)) {
                return true;
            }
            return !fluidStack.isFluidStackEqual((FluidStack)newValue);
        }
        return !oldValue.equals(newValue);
    }

    @Deprecated
    public static Object copyWhenNecessary(Object value) {
        if (value instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)value;
            return itemStack.m_41777_();
        }
        if (value instanceof FluidStack) {
            FluidStack fluidStack = (FluidStack)value;
            return fluidStack.copy();
        }
        if (value instanceof BlockPos) {
            BlockPos blockPos = (BlockPos)value;
            return blockPos.m_7949_();
        }
        return value;
    }

    public static Object copyArrayLike(Object value, boolean isArray) {
        if (isArray) {
            Class<?> componentType = value.getClass().getComponentType();
            if (componentType.isPrimitive()) {
                Object result = Array.newInstance(componentType, Array.getLength(value));
                System.arraycopy(value, 0, result, 0, Array.getLength(value));
                return result;
            }
            Object[] array = (Object[])value;
            Object[] result = new Object[array.length];
            for (int i = 0; i < array.length; ++i) {
                result[i] = SyncUtils.copyWhenNecessary(array[i]);
            }
            return result;
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            Object[] result = new Object[collection.size()];
            int i = 0;
            for (Object o : collection) {
                result[i++] = SyncUtils.copyWhenNecessary(o);
            }
            return result;
        }
        throw new IllegalArgumentException("Value %s is not an array or collection".formatted(value));
    }
}

