/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.side.item.forge;

import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.side.item.ItemTransferHelper;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;

public class ItemTransferHelperImpl
extends ItemTransferHelper {
    public static IItemHandler toItemHandler(final IItemTransfer itemTransfer) {
        return new IItemHandler(){

            public int getSlots() {
                return itemTransfer.getSlots();
            }

            @NotNull
            public ItemStack getStackInSlot(int slot) {
                return itemTransfer.getStackInSlot(slot);
            }

            @NotNull
            public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
                return itemTransfer.insertItem(slot, stack, simulate, !simulate);
            }

            @NotNull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                return itemTransfer.extractItem(slot, amount, simulate, !simulate);
            }

            public int getSlotLimit(int slot) {
                return itemTransfer.getSlotLimit(slot);
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return itemTransfer.isItemValid(slot, stack);
            }
        };
    }

    public static IItemTransfer toItemTransfer(final IItemHandler handler) {
        return new IItemTransfer(){

            @Override
            public int getSlots() {
                return handler.getSlots();
            }

            @Override
            @NotNull
            public ItemStack getStackInSlot(int slot) {
                return handler.getStackInSlot(slot);
            }

            @Override
            public void setStackInSlot(int index, ItemStack stack) {
                if (handler instanceof IItemHandlerModifiable) {
                    IItemHandlerModifiable modifiable = (IItemHandlerModifiable)handler;
                    modifiable.setStackInSlot(index, stack);
                } else {
                    IItemTransfer.super.setStackInSlot(index, stack);
                }
            }

            @Override
            @NotNull
            public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate, boolean notifyChanges) {
                return handler.insertItem(slot, stack, simulate);
            }

            @Override
            @NotNull
            public ItemStack extractItem(int slot, int amount, boolean simulate, boolean notifyChanges) {
                return handler.extractItem(slot, amount, simulate);
            }

            @Override
            public int getSlotLimit(int slot) {
                return handler.getSlotLimit(slot);
            }

            @Override
            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return handler.isItemValid(slot, stack);
            }

            @Override
            @NotNull
            public Object createSnapshot() {
                return new Object();
            }

            @Override
            public void restoreFromSnapshot(Object snapshot) {
            }
        };
    }

    public static IItemTransfer getItemTransfer(Level level, BlockPos pos, @Nullable Direction direction) {
        Optional cap;
        BlockEntity blockEntity;
        if (level.m_8055_(pos).m_155947_() && (blockEntity = level.m_7702_(pos)) != null && (cap = blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, direction).resolve()).isPresent()) {
            return ItemTransferHelperImpl.toItemTransfer((IItemHandler)cap.get());
        }
        return null;
    }

    public static void exportToTarget(IItemTransfer source, int maxAmount, Predicate<ItemStack> predicate, Level level, BlockPos pos, @Nullable Direction direction) {
        Optional cap;
        BlockEntity blockEntity;
        if (level.m_8055_(pos).m_155947_() && (blockEntity = level.m_7702_(pos)) != null && (cap = blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, direction).resolve()).isPresent()) {
            IItemHandler target = (IItemHandler)cap.get();
            for (int srcIndex = 0; srcIndex < source.getSlots(); ++srcIndex) {
                ItemStack sourceStack = source.extractItem(srcIndex, Integer.MAX_VALUE, true, false);
                if (sourceStack.m_41619_() || !predicate.test(sourceStack)) continue;
                ItemStack remainder = ItemTransferHelperImpl.insertItem(target, sourceStack, true);
                int amountToInsert = sourceStack.m_41613_() - remainder.m_41613_();
                if (amountToInsert <= 0) continue;
                sourceStack = source.extractItem(srcIndex, Math.min(maxAmount, amountToInsert), false, true);
                ItemTransferHelperImpl.insertItem(target, sourceStack, false);
                maxAmount -= Math.min(maxAmount, amountToInsert);
                if (maxAmount > 0) continue;
                return;
            }
        }
    }

    public static ItemStack insertItem(IItemHandler handler, ItemStack stack, boolean simulate) {
        if (handler == null || stack.m_41619_()) {
            return stack;
        }
        if (!stack.m_41753_()) {
            return ItemTransferHelperImpl.insertToEmpty(handler, stack, simulate);
        }
        IntArrayList emptySlots = new IntArrayList();
        int slots = handler.getSlots();
        for (int i = 0; i < slots; ++i) {
            ItemStack slotStack = handler.getStackInSlot(i);
            if (slotStack.m_41619_()) {
                emptySlots.add(i);
            }
            if (!ItemHandlerHelper.canItemStacksStackRelaxed((ItemStack)stack, (ItemStack)slotStack) || !(stack = handler.insertItem(i, stack, simulate)).m_41619_()) continue;
            return ItemStack.f_41583_;
        }
        IntListIterator intListIterator = emptySlots.iterator();
        while (intListIterator.hasNext()) {
            int slot = (Integer)intListIterator.next();
            stack = handler.insertItem(slot, stack, simulate);
            if (!stack.m_41619_()) continue;
            return ItemStack.f_41583_;
        }
        return stack;
    }

    public static ItemStack insertToEmpty(IItemHandler handler, ItemStack stack, boolean simulate) {
        if (handler == null || stack.m_41619_()) {
            return stack;
        }
        int slots = handler.getSlots();
        for (int i = 0; i < slots; ++i) {
            ItemStack slotStack = handler.getStackInSlot(i);
            if (!slotStack.m_41619_() || !(stack = handler.insertItem(i, stack, simulate)).m_41619_()) continue;
            return ItemStack.f_41583_;
        }
        return stack;
    }

    public static void importToTarget(IItemTransfer target, int maxAmount, Predicate<ItemStack> predicate, Level level, BlockPos pos, @Nullable Direction direction) {
        Optional cap;
        BlockEntity blockEntity;
        if (level.m_8055_(pos).m_155947_() && (blockEntity = level.m_7702_(pos)) != null && (cap = blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, direction).resolve()).isPresent()) {
            IItemHandler source = (IItemHandler)cap.get();
            for (int srcIndex = 0; srcIndex < source.getSlots(); ++srcIndex) {
                ItemStack sourceStack = source.extractItem(srcIndex, Integer.MAX_VALUE, true);
                if (sourceStack.m_41619_() || !predicate.test(sourceStack)) continue;
                ItemStack remainder = ItemTransferHelperImpl.insertItem(target, sourceStack, true);
                int amountToInsert = sourceStack.m_41613_() - remainder.m_41613_();
                if (amountToInsert > 0) {
                    sourceStack = source.extractItem(srcIndex, Math.min(maxAmount, amountToInsert), false);
                    ItemTransferHelperImpl.insertItem(target, sourceStack, false);
                    maxAmount -= Math.min(maxAmount, amountToInsert);
                }
                if (maxAmount > 0) continue;
                return;
            }
        }
    }

    public static ItemStack insertItem(IItemTransfer handler, ItemStack stack, boolean simulate) {
        if (handler == null || stack.m_41619_()) {
            return stack;
        }
        if (!stack.m_41753_()) {
            return ItemTransferHelperImpl.insertToEmpty(handler, stack, simulate);
        }
        IntArrayList emptySlots = new IntArrayList();
        int slots = handler.getSlots();
        for (int i = 0; i < slots; ++i) {
            ItemStack slotStack = handler.getStackInSlot(i);
            if (slotStack.m_41619_()) {
                emptySlots.add(i);
            }
            if (!ItemHandlerHelper.canItemStacksStackRelaxed((ItemStack)stack, (ItemStack)slotStack) || !(stack = handler.insertItem(i, stack, simulate, !simulate)).m_41619_()) continue;
            return ItemStack.f_41583_;
        }
        IntListIterator intListIterator = emptySlots.iterator();
        while (intListIterator.hasNext()) {
            int slot = (Integer)intListIterator.next();
            stack = handler.insertItem(slot, stack, simulate, !simulate);
            if (!stack.m_41619_()) continue;
            return ItemStack.f_41583_;
        }
        return stack;
    }

    public static ItemStack insertToEmpty(IItemTransfer handler, ItemStack stack, boolean simulate) {
        if (handler == null || stack.m_41619_()) {
            return stack;
        }
        int slots = handler.getSlots();
        for (int i = 0; i < slots; ++i) {
            ItemStack slotStack = handler.getStackInSlot(i);
            if (!slotStack.m_41619_() || !(stack = handler.insertItem(i, stack, simulate, !simulate)).m_41619_()) continue;
            return ItemStack.f_41583_;
        }
        return stack;
    }
}

