/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.pipelike;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.pipelike.Node;
import com.lowdragmc.lowdraglib.pipelike.PipeNet;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public abstract class PipeNetWalker<NodeDataType, Net extends PipeNet<NodeDataType>> {
    protected PipeNetWalker<NodeDataType, Net> root;
    protected final Net pipeNet;
    protected final LongSet walked = new LongOpenHashSet();
    protected final List<Direction> pipes = new ArrayList<Direction>();
    protected List<PipeNetWalker<NodeDataType, Net>> walkers;
    protected final BlockPos.MutableBlockPos currentPos;
    private int walkedBlocks;
    private boolean invalid;
    private boolean running;

    protected PipeNetWalker(Net pipeNet, BlockPos sourcePipe, int walkedBlocks) {
        this.pipeNet = pipeNet;
        this.walkedBlocks = walkedBlocks;
        this.currentPos = sourcePipe.m_122032_();
        this.root = this;
    }

    @Nonnull
    protected abstract PipeNetWalker<NodeDataType, Net> createSubWalker(Net var1, Direction var2, BlockPos var3, int var4);

    protected void checkNeighbour(Node<NodeDataType> pipeNode, BlockPos pipePos, Direction faceToNeighbour, @Nullable BlockEntity neighbourTile) {
    }

    protected boolean checkPipe(Node<NodeDataType> pipeNode, BlockPos pos) {
        return true;
    }

    protected Direction[] getSurroundingPipeSides() {
        return Direction.values();
    }

    protected void onRemoveSubWalker(PipeNetWalker<NodeDataType, Net> subWalker) {
    }

    public void traversePipeNet() {
        this.traversePipeNet(32768);
    }

    public void traversePipeNet(int maxWalks) {
        if (this.invalid) {
            throw new IllegalStateException("This walker already walked. Create a new one if you want to walk again");
        }
        int i = 0;
        this.running = true;
        while (this.running && !this.walk() && i++ < maxWalks) {
        }
        this.running = false;
        this.root.walked.clear();
        if (i >= maxWalks) {
            LDLib.LOGGER.warn("The walker reached the maximum amount of walks {}", (Object)i);
        }
        this.invalid = true;
    }

    private boolean walk() {
        if (this.walkers == null) {
            this.checkPos();
            if (this.pipes.size() == 0) {
                return true;
            }
            if (this.pipes.size() == 1) {
                this.currentPos.m_122173_(this.pipes.get(0));
                ++this.walkedBlocks;
                return !this.isRunning();
            }
            this.walkers = new ArrayList<PipeNetWalker<NodeDataType, Net>>();
            for (Direction side : this.pipes) {
                PipeNetWalker<NodeDataType, Net> walker = this.createSubWalker(this.pipeNet, side, this.currentPos.m_121945_(side), this.walkedBlocks + 1);
                walker.root = this.root;
                this.walkers.add(walker);
            }
        }
        Iterator<PipeNetWalker<NodeDataType, Net>> iterator = this.walkers.iterator();
        while (iterator.hasNext()) {
            PipeNetWalker<NodeDataType, Net> walker = iterator.next();
            if (!walker.walk()) continue;
            this.onRemoveSubWalker(walker);
            iterator.remove();
        }
        return !this.isRunning() || this.walkers.size() == 0;
    }

    private void checkPos() {
        this.pipes.clear();
        Node pipeNode = ((PipeNet)this.pipeNet).getNodeAt((BlockPos)this.currentPos);
        if (pipeNode != null) {
            if (!this.checkPipe(pipeNode, (BlockPos)this.currentPos)) {
                return;
            }
            this.root.walked.add(this.currentPos.m_121878_());
            for (Direction accessSide : this.getSurroundingPipeSides()) {
                if (this.isWalked(this.currentPos.m_121945_(accessSide)) || pipeNode.isBlocked(accessSide)) continue;
                if (((PipeNet)this.pipeNet).isNodeConnectedTo((BlockPos)this.currentPos, accessSide)) {
                    this.pipes.add(accessSide);
                    continue;
                }
                this.checkNeighbour(pipeNode, (BlockPos)this.currentPos, accessSide, ((PipeNet)this.pipeNet).getLevel().m_7702_((BlockPos)this.currentPos));
            }
        }
    }

    protected boolean isWalked(BlockPos pos) {
        return this.root.walked.contains(pos.m_121878_());
    }

    public void stop() {
        this.root.running = false;
    }

    public boolean isRunning() {
        return this.root.running;
    }

    public ServerLevel getLevel() {
        return ((PipeNet)this.pipeNet).getLevel();
    }

    public BlockPos getCurrentPos() {
        return this.currentPos.m_7949_();
    }

    public int getWalkedBlocks() {
        return this.walkedBlocks;
    }

    public boolean isInvalid() {
        return this.invalid;
    }
}

