/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.kjs.ui;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.gui.factory.UIFactory;
import com.lowdragmc.lowdraglib.gui.modular.IUIHolder;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.kjs.ui.UIEvents;
import dev.latvian.mods.kubejs.event.EventJS;
import dev.latvian.mods.kubejs.event.EventResult;
import dev.latvian.mods.kubejs.level.BlockContainerJS;
import dev.latvian.mods.kubejs.typings.Info;
import dev.latvian.mods.rhino.util.RemapForJS;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockUIJSFactory
extends UIFactory<BlockAccess> {
    public static final BlockUIJSFactory INSTANCE = new BlockUIJSFactory();

    private BlockUIJSFactory() {
        super(LDLib.location("block_js"));
    }

    @RemapForJS(value="openUI")
    @Info(value="Opens a UI for a player at a specific block position.")
    public boolean kjs$openUI(Player player, BlockPos pos, String uiName) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            return this.openUI(new BlockAccess(pos, uiName), serverPlayer);
        }
        return false;
    }

    @Override
    protected ModularUI createUITemplate(BlockAccess holder, Player entityPlayer) {
        final Level level = entityPlayer.m_9236_();
        final BlockPos pos = holder.pos;
        final BlockState block = level.m_8055_(pos);
        final BlockEntity blockEntity = level.m_7702_(pos);
        EventResult result = UIEvents.BLOCK.post((EventJS)new UIEvents.BlockUIEventJS(level, pos, new BlockContainerJS(level, pos), entityPlayer), (Object)holder.uiName);
        Object object = result.value();
        if (object instanceof WidgetGroup) {
            WidgetGroup root = (WidgetGroup)object;
            if (!result.interruptFalse() && !result.error()) {
                return new ModularUI(root, new IUIHolder(){

                    @Override
                    public ModularUI createUI(Player entityPlayer) {
                        return null;
                    }

                    @Override
                    public boolean isInvalid() {
                        if (blockEntity != null && blockEntity.m_58901_()) {
                            return true;
                        }
                        return !level.m_8055_(pos).m_60713_(block.m_60734_());
                    }

                    @Override
                    public boolean isRemote() {
                        return level.f_46443_;
                    }

                    @Override
                    public void markAsDirty() {
                        if (blockEntity != null) {
                            blockEntity.m_6596_();
                        }
                    }
                }, entityPlayer);
            }
        }
        return null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected BlockAccess readHolderFromSyncData(FriendlyByteBuf syncData) {
        return new BlockAccess(syncData.m_130135_(), syncData.m_130277_());
    }

    @Override
    protected void writeHolderToSyncData(FriendlyByteBuf syncData, BlockAccess holder) {
        syncData.m_130064_(holder.pos());
        syncData.m_130070_(holder.uiName());
    }

    public record BlockAccess(BlockPos pos, String uiName) {
    }
}

