/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.widget;

import com.google.common.collect.Lists;
import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.gui.editor.annotation.ConfigSetter;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurableWidget;
import com.lowdragmc.lowdraglib.gui.ingredient.IGhostIngredientTarget;
import com.lowdragmc.lowdraglib.gui.ingredient.Target;
import com.lowdragmc.lowdraglib.gui.widget.PhantomFluidWidget;
import com.lowdragmc.lowdraglib.gui.widget.TankWidget;
import com.lowdragmc.lowdraglib.misc.ItemStackTransfer;
import com.lowdragmc.lowdraglib.side.fluid.FluidTransferHelper;
import com.lowdragmc.lowdraglib.side.fluid.IFluidStorage;
import com.lowdragmc.lowdraglib.side.fluid.IFluidTransfer;
import dev.architectury.fluid.FluidStack;
import dev.emi.emi.api.stack.EmiStack;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.ITypedIngredient;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@LDLRegister(name="phantom_tank_slot", group="widget.container")
public class PhantomTankWidget
extends TankWidget
implements IGhostIngredientTarget,
IConfigurableWidget {
    private Consumer<com.lowdragmc.lowdraglib.side.fluid.FluidStack> fluidStackUpdater;

    public PhantomTankWidget() {
        this.allowClickFilled = false;
        this.allowClickDrained = false;
    }

    public PhantomTankWidget(IFluidStorage fluidTank, int x, int y) {
        super(fluidTank, x, y, false, false);
    }

    public PhantomTankWidget(@Nullable IFluidStorage fluidTank, int x, int y, int width, int height) {
        super(fluidTank, x, y, width, height, false, false);
    }

    public PhantomTankWidget(IFluidTransfer fluidTank, int tank, int x, int y) {
        super(fluidTank, tank, x, y, false, false);
    }

    public PhantomTankWidget(@Nullable IFluidTransfer fluidTank, int tank, int x, int y, int width, int height) {
        super(fluidTank, tank, x, y, width, height, false, false);
    }

    public PhantomTankWidget setIFluidStackUpdater(Consumer<com.lowdragmc.lowdraglib.side.fluid.FluidStack> fluidStackUpdater) {
        this.fluidStackUpdater = fluidStackUpdater;
        return this;
    }

    @Override
    @ConfigSetter(field="allowClickFilled")
    public PhantomTankWidget setAllowClickFilled(boolean v) {
        return this;
    }

    @Override
    @ConfigSetter(field="allowClickDrained")
    public PhantomTankWidget setAllowClickDrained(boolean v) {
        return this;
    }

    public static com.lowdragmc.lowdraglib.side.fluid.FluidStack drainFrom(Object ingredient) {
        ItemStack itemStack;
        IFluidTransfer handler;
        Ingredient ing;
        ItemStack[] items;
        if (ingredient instanceof Ingredient && (items = (ing = (Ingredient)ingredient).m_43908_()).length > 0) {
            ingredient = items[0];
        }
        if (ingredient instanceof ItemStack && (handler = FluidTransferHelper.getFluidTransfer(new ItemStackTransfer(itemStack = (ItemStack)ingredient), 0)) != null) {
            return handler.drain(Long.MAX_VALUE, true);
        }
        return com.lowdragmc.lowdraglib.side.fluid.FluidStack.empty();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Target> getPhantomTargets(Object ingredient) {
        if (LDLib.isReiLoaded() && ingredient instanceof FluidStack) {
            FluidStack fluidStack = (FluidStack)ingredient;
            ingredient = com.lowdragmc.lowdraglib.side.fluid.FluidStack.create(fluidStack.getFluid(), fluidStack.getAmount(), fluidStack.getTag());
        }
        if (LDLib.isEmiLoaded() && ingredient instanceof EmiStack) {
            EmiStack fluidEmiStack = (EmiStack)ingredient;
            Fluid fluid = (Fluid)fluidEmiStack.getKeyOfType(Fluid.class);
            if (fluid == null) {
                Item item = (Item)fluidEmiStack.getKeyOfType(Item.class);
                Object object = ingredient = item == null ? null : new ItemStack((ItemLike)item, (int)fluidEmiStack.getAmount());
                if (ingredient instanceof ItemStack) {
                    ItemStack itemStack = (ItemStack)ingredient;
                    itemStack.m_41751_(fluidEmiStack.getNbt());
                }
            } else {
                ingredient = com.lowdragmc.lowdraglib.side.fluid.FluidStack.create(fluid, fluidEmiStack.getAmount() == 0L ? 1000L : fluidEmiStack.getAmount(), fluidEmiStack.getNbt());
            }
        }
        if (LDLib.isJeiLoaded() && ingredient instanceof ITypedIngredient) {
            ITypedIngredient typedIngredient = (ITypedIngredient)ingredient;
            ingredient = PhantomFluidWidget.checkJEIIngredient(typedIngredient.getIngredient());
        }
        if (!(ingredient instanceof com.lowdragmc.lowdraglib.side.fluid.FluidStack) && PhantomTankWidget.drainFrom(ingredient).isEmpty()) {
            return Collections.emptyList();
        }
        final Rect2i rectangle = this.toRectangleBox();
        return Lists.newArrayList((Object[])new Target[]{new Target(){

            @Override
            @Nonnull
            public Rect2i getArea() {
                return rectangle;
            }

            @Override
            public void accept(@Nonnull Object ingredient) {
                com.lowdragmc.lowdraglib.side.fluid.FluidStack ingredientStack;
                Object fluidStack;
                if (LDLib.isReiLoaded() && ingredient instanceof FluidStack) {
                    fluidStack = (FluidStack)ingredient;
                    ingredient = com.lowdragmc.lowdraglib.side.fluid.FluidStack.create(fluidStack.getFluid(), fluidStack.getAmount(), fluidStack.getTag());
                }
                if (LDLib.isEmiLoaded() && ingredient instanceof EmiStack) {
                    EmiStack fluidEmiStack = (EmiStack)ingredient;
                    Fluid fluid = (Fluid)fluidEmiStack.getKeyOfType(Fluid.class);
                    if (fluid == null) {
                        Item item = (Item)fluidEmiStack.getKeyOfType(Item.class);
                        Object object = ingredient = item == null ? null : new ItemStack((ItemLike)item, (int)fluidEmiStack.getAmount());
                        if (ingredient instanceof ItemStack) {
                            ItemStack itemStack = (ItemStack)ingredient;
                            itemStack.m_41751_(fluidEmiStack.getNbt());
                        }
                    } else {
                        ingredient = com.lowdragmc.lowdraglib.side.fluid.FluidStack.create(fluid, fluidEmiStack.getAmount() == 0L ? 1000L : fluidEmiStack.getAmount(), fluidEmiStack.getNbt());
                    }
                }
                if (LDLib.isJeiLoaded()) {
                    ingredient = PhantomFluidWidget.checkJEIIngredient(ingredient);
                }
                if (ingredient instanceof com.lowdragmc.lowdraglib.side.fluid.FluidStack) {
                    fluidStack = (com.lowdragmc.lowdraglib.side.fluid.FluidStack)ingredient;
                    ingredientStack = fluidStack;
                } else {
                    ingredientStack = PhantomTankWidget.drainFrom(ingredient);
                }
                if (ingredientStack != null && !ingredientStack.isEmpty()) {
                    CompoundTag tagCompound = ingredientStack.saveToTag(new CompoundTag());
                    PhantomTankWidget.this.writeClientAction(2, buffer -> buffer.m_130079_(tagCompound));
                }
                if (PhantomTankWidget.this.isClientSideWidget && PhantomTankWidget.this.fluidTank != null) {
                    PhantomTankWidget.this.fluidTank.drain(PhantomTankWidget.this.fluidTank.getTankCapacity(PhantomTankWidget.this.tank), false);
                    if (ingredientStack != null) {
                        PhantomTankWidget.this.fluidTank.fill(ingredientStack.copy(), false);
                    }
                    if (PhantomTankWidget.this.fluidStackUpdater != null) {
                        PhantomTankWidget.this.fluidStackUpdater.accept(ingredientStack);
                    }
                }
            }
        }});
    }

    @Override
    public void handleClientAction(int id, FriendlyByteBuf buffer) {
        if (id == 1) {
            this.handlePhantomClick();
        } else if (id == 2) {
            com.lowdragmc.lowdraglib.side.fluid.FluidStack fluidStack = com.lowdragmc.lowdraglib.side.fluid.FluidStack.loadFromTag(buffer.m_130260_());
            if (this.fluidTank == null) {
                return;
            }
            this.fluidTank.drain(this.fluidTank.getTankCapacity(this.tank), false);
            if (fluidStack != null) {
                this.fluidTank.fill(fluidStack.copy(), false);
            }
            if (this.fluidStackUpdater != null) {
                this.fluidStackUpdater.accept(fluidStack);
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isMouseOverElement(mouseX, mouseY)) {
            if (this.isClientSideWidget) {
                this.handlePhantomClick();
            } else {
                this.writeClientAction(1, buffer -> {});
            }
            return true;
        }
        return false;
    }

    private void handlePhantomClick() {
        if (this.fluidTank == null) {
            return;
        }
        ItemStack itemStack = this.gui.getModularUIContainer().m_142621_().m_41777_();
        if (!itemStack.m_41619_()) {
            itemStack.m_41764_(1);
            IFluidTransfer handler = FluidTransferHelper.getFluidTransfer(this.gui.entityPlayer, this.gui.getModularUIContainer());
            if (handler != null) {
                com.lowdragmc.lowdraglib.side.fluid.FluidStack resultFluid = handler.drain(Integer.MAX_VALUE, true);
                this.fluidTank.drain(this.fluidTank.getTankCapacity(this.tank), false);
                this.fluidTank.fill(resultFluid.copy(), false);
                if (this.fluidStackUpdater != null) {
                    this.fluidStackUpdater.accept(resultFluid);
                }
            }
        } else {
            this.fluidTank.drain(this.fluidTank.getTankCapacity(this.tank), false);
            if (this.fluidStackUpdater != null) {
                this.fluidStackUpdater.accept(null);
            }
        }
    }
}

