/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.texture;

import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberColor;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberRange;
import com.lowdragmc.lowdraglib.gui.texture.TransformTexture;
import com.lowdragmc.lowdraglib.gui.util.DrawerHelper;
import com.lowdragmc.lowdraglib.utils.Rect;
import java.awt.Color;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector4f;

@LDLRegister(name="color_border_texture", group="texture")
public class ColorBorderTexture
extends TransformTexture {
    @Configurable
    @NumberColor
    public int color;
    @Configurable
    @NumberRange(range={-100.0, 100.0})
    public int border;
    @Configurable
    @NumberRange(range={0.0, 3.4028234663852886E38}, wheel=1.0)
    public float radiusLTInner;
    @Configurable
    @NumberRange(range={0.0, 3.4028234663852886E38}, wheel=1.0)
    public float radiusLBInner;
    @Configurable
    @NumberRange(range={0.0, 3.4028234663852886E38}, wheel=1.0)
    public float radiusRTInner;
    @Configurable
    @NumberRange(range={0.0, 3.4028234663852886E38}, wheel=1.0)
    public float radiusRBInner;
    @Configurable
    @NumberRange(range={0.0, 3.4028234663852886E38}, wheel=1.0)
    public float radiusLTOuter;
    @Configurable
    @NumberRange(range={0.0, 3.4028234663852886E38}, wheel=1.0)
    public float radiusLBOuter;
    @Configurable
    @NumberRange(range={0.0, 3.4028234663852886E38}, wheel=1.0)
    public float radiusRTOuter;
    @Configurable
    @NumberRange(range={0.0, 3.4028234663852886E38}, wheel=1.0)
    public float radiusRBOuter;

    public ColorBorderTexture() {
        this(-2, 1326448095);
    }

    public ColorBorderTexture(int border, int color) {
        this.color = color;
        this.border = border;
    }

    public ColorBorderTexture(int border, Color color) {
        this.color = color.getRGB();
        this.border = border;
    }

    public ColorBorderTexture setBorder(int border) {
        this.border = border;
        return this;
    }

    @Override
    public ColorBorderTexture setColor(int color) {
        this.color = color;
        return this;
    }

    public ColorBorderTexture setRadius(float radius) {
        this.radiusLBInner = radius - (float)this.border;
        this.radiusRTInner = radius - (float)this.border;
        this.radiusRBInner = radius - (float)this.border;
        this.radiusLTInner = radius - (float)this.border;
        this.radiusLBOuter = radius;
        this.radiusRTOuter = radius;
        this.radiusRBOuter = radius;
        this.radiusLTOuter = radius;
        return this;
    }

    public ColorBorderTexture setLeftRadius(float radius) {
        this.setLeftRadiusInner(radius);
        this.setLeftRadiusOuter(radius);
        return this;
    }

    public ColorBorderTexture setRightRadius(float radius) {
        this.setRightRadiusInner(radius);
        this.setRightRadiusOuter(radius);
        return this;
    }

    public ColorBorderTexture setTopRadius(float radius) {
        this.setTopRadiusInner(radius);
        this.setTopRadiusOuter(radius);
        return this;
    }

    public ColorBorderTexture setBottomRadius(float radius) {
        this.setBottomRadiusInner(radius);
        this.setBottomRadiusOuter(radius);
        return this;
    }

    public ColorBorderTexture setLeftRadiusInner(float radius) {
        this.radiusLBInner = radius;
        this.radiusLTInner = radius;
        return this;
    }

    public ColorBorderTexture setRightRadiusInner(float radius) {
        this.radiusRTInner = radius;
        this.radiusRBInner = radius;
        return this;
    }

    public ColorBorderTexture setTopRadiusInner(float radius) {
        this.radiusRTInner = radius;
        this.radiusLTInner = radius;
        return this;
    }

    public ColorBorderTexture setBottomRadiusInner(float radius) {
        this.radiusLBInner = radius;
        this.radiusRBInner = radius;
        return this;
    }

    public ColorBorderTexture setLeftRadiusOuter(float radius) {
        this.radiusLBOuter = radius;
        this.radiusLTOuter = radius;
        return this;
    }

    public ColorBorderTexture setRightRadiusOuter(float radius) {
        this.radiusRTOuter = radius;
        this.radiusRBOuter = radius;
        return this;
    }

    public ColorBorderTexture setTopRadiusOuter(float radius) {
        this.radiusRTOuter = radius;
        this.radiusLTOuter = radius;
        return this;
    }

    public ColorBorderTexture setBottomRadiusOuter(float radius) {
        this.radiusLBOuter = radius;
        this.radiusRBOuter = radius;
        return this;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void drawInternal(GuiGraphics graphics, int mouseX, int mouseY, float x, float y, int width, int height) {
        if (width == 0 || height == 0) {
            return;
        }
        if (this.radiusLTInner > 0.0f || this.radiusLBInner > 0.0f || this.radiusRTInner > 0.0f || this.radiusRBInner > 0.0f || this.radiusLTOuter > 0.0f || this.radiusLBOuter > 0.0f || this.radiusRTOuter > 0.0f || this.radiusRBOuter > 0.0f) {
            float radius = (float)Math.min(width, height) / 2.0f;
            DrawerHelper.drawFrameRoundBox(graphics, Rect.ofRelative((int)x, width, (int)y, height), this.border, new Vector4f(Math.min(radius, this.radiusRTInner), Math.min(this.radiusRBInner, radius), Math.min(radius, this.radiusLTInner), Math.min(radius, this.radiusLBInner)), new Vector4f(Math.min(radius, this.radiusRTOuter), Math.min(this.radiusRBOuter, radius), Math.min(radius, this.radiusLTOuter), Math.min(radius, this.radiusLBOuter)), this.color);
        } else {
            DrawerHelper.drawBorder(graphics, (int)x, (int)y, width, height, this.color, this.border);
        }
    }

    public void setRadiusLTInner(float radiusLTInner) {
        this.radiusLTInner = radiusLTInner;
    }

    public void setRadiusLBInner(float radiusLBInner) {
        this.radiusLBInner = radiusLBInner;
    }

    public void setRadiusRTInner(float radiusRTInner) {
        this.radiusRTInner = radiusRTInner;
    }

    public void setRadiusRBInner(float radiusRBInner) {
        this.radiusRBInner = radiusRBInner;
    }

    public void setRadiusLTOuter(float radiusLTOuter) {
        this.radiusLTOuter = radiusLTOuter;
    }

    public void setRadiusLBOuter(float radiusLBOuter) {
        this.radiusLBOuter = radiusLBOuter;
    }

    public void setRadiusRTOuter(float radiusRTOuter) {
        this.radiusRTOuter = radiusRTOuter;
    }

    public void setRadiusRBOuter(float radiusRBOuter) {
        this.radiusRBOuter = radiusRBOuter;
    }
}

