/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.graphprocessor.nodes.minecraft.item;

import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.InputPort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.OutputPort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.BaseNode;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.NodePort;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import net.minecraft.world.item.ItemStack;

@LDLRegister(name="item transfer info", group="graph_processor.node.minecraft.item")
public class ItemTransferInfoNode
extends BaseNode {
    @InputPort(name="item transfer")
    public IItemTransfer itemTransfer;
    @InputPort(name="slot index")
    public Integer slot;
    @OutputPort(name="slot size")
    public int slots;
    @OutputPort
    public ItemStack itemstack;
    @OutputPort(name="slot limit")
    public int slotLimit;
    @Configurable(name="slot index")
    public int internalSlot;

    @Override
    public void process() {
        if (this.itemTransfer != null) {
            this.slots = this.itemTransfer.getSlots();
            int realSlot = this.slot == null ? this.internalSlot : this.slot;
            this.itemstack = this.itemTransfer.getStackInSlot(realSlot);
            this.slotLimit = this.itemTransfer.getSlotLimit(realSlot);
        }
    }

    @Override
    public void buildConfigurator(ConfiguratorGroup father) {
        for (NodePort port : this.getInputPorts()) {
            if (!port.fieldName.equals("slot") || port.getEdges().isEmpty()) continue;
            return;
        }
        super.buildConfigurator(father);
    }
}

