/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.graphprocessor.nodes.minecraft.item;

import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.InputPort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.OutputPort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.BaseNode;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.NodePort;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

@LDLRegister(name="itemstack", group="graph_processor.node.minecraft.item")
public class ItemStackNode
extends BaseNode {
    @InputPort
    public Object in;
    @InputPort
    public Item item;
    @InputPort
    public Integer count;
    @InputPort
    public CompoundTag tag;
    @OutputPort
    public ItemStack out = null;
    @Configurable(name="itemstack", canCollapse=false, collapse=false)
    public ItemStack internalValue = new ItemStack((ItemLike)Items.f_41852_);

    @Override
    public int getMinWidth() {
        return 100;
    }

    @Override
    public void process() {
        if (this.in == null) {
            this.out = this.internalValue.m_41777_();
        } else {
            Object object = this.in;
            if (object instanceof ItemStack) {
                ItemStack itemStack = (ItemStack)object;
                this.out = itemStack.m_41777_();
            } else {
                object = this.in;
                if (object instanceof CompoundTag) {
                    CompoundTag itemTag = (CompoundTag)object;
                    this.out = ItemStack.m_41712_((CompoundTag)itemTag);
                } else {
                    this.out = new ItemStack((ItemLike)Items.f_41852_);
                }
            }
        }
        if (this.item != null) {
            ItemStack stack = new ItemStack((ItemLike)this.item, this.out.m_41613_());
            if (this.out.m_41782_()) {
                stack.m_41751_(this.out.m_41783_());
            }
            this.out = stack;
        }
        if (this.count != null) {
            this.out.m_41764_(this.count.intValue());
        }
        if (this.tag != null) {
            this.out.m_41751_(this.tag);
        }
    }

    @Override
    public void buildConfigurator(ConfiguratorGroup father) {
        for (NodePort port : this.getInputPorts()) {
            if (!port.fieldName.equals("in") || port.getEdges().isEmpty()) continue;
            return;
        }
        super.buildConfigurator(father);
    }
}

