/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.graphprocessor.nodes.minecraft.fluid;

import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.InputPort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.OutputPort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.BaseNode;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.NodePort;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.side.fluid.IFluidTransfer;

@LDLRegister(name="fluid transfer info", group="graph_processor.node.minecraft.fluid")
public class FluidTransferInfoNode
extends BaseNode {
    @InputPort(name="fluid transfer")
    public IFluidTransfer fluidTransfer;
    @InputPort(name="tank index")
    public Integer tank;
    @OutputPort(name="tank size")
    public int tanks;
    @OutputPort
    public FluidStack fluidstack;
    @OutputPort(name="capacity")
    public int capacity;
    @Configurable(name="tank index")
    public int internalTank;

    @Override
    public void process() {
        if (this.fluidTransfer != null) {
            this.tanks = this.fluidTransfer.getTanks();
            int realTank = this.tank == null ? this.internalTank : this.tank;
            this.fluidstack = this.fluidTransfer.getFluidInTank(realTank);
            this.capacity = (int)this.fluidTransfer.getTankCapacity(realTank);
        }
    }

    @Override
    public void buildConfigurator(ConfiguratorGroup father) {
        for (NodePort port : this.getInputPorts()) {
            if (!port.fieldName.equals("slot") || port.getEdges().isEmpty()) continue;
            return;
        }
        super.buildConfigurator(father);
    }
}

